//
// Created by zxm on 2022/8/22.
//
#include <QCommandLineParser>
#include <QDebug>
#include <stdio.h>
#include "utils/environments.h"
#include "BootVersionMgr.h"

int main(int argc, char **argv)
{
    const char kAppDesc[] = "uos-recovery-tool";
    QCoreApplication app(argc, argv);
    app.setApplicationVersion(VERSION);

    QCommandLineOption opActionType(QStringList()<<"a"<<"action",
                                    QString(QObject::tr("Choose an action type:\n") +
                                    "    bootlist:    " + QObject::tr("get boot list")));
    opActionType.setValueName("type");

    // init command line
    QCommandLineParser parser;
    parser.setApplicationDescription(kAppDesc);
    parser.addHelpOption();
    parser.addVersionOption();
    parser.addOption(opActionType);
    parser.process(app);

    if (!parser.parse(app.arguments())) {
        parser.showHelp(-1);
    }

    QString curAction = parser.value(opActionType);
    if (curAction == "bootlist") {
        BootVersionMgr bootVerMgr;
        QString bootList = bootVerMgr.getBootList();
    //    qInfo()<<bootList.toLocal8Bit().data()<<"\n";  // 原子更新修改了实现，只从标准输出获取数据
        printf("%s\n",bootList.toLocal8Bit().data());
    } else {
        parser.showHelp(-1);
    }

    return 0;
}
