/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization.test;

import com.sourceforge.knecs.dsm.authorization.AccessException;
import com.sourceforge.knecs.dsm.authorization.DSIAuthService;
import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.NSProperty;
import org.apache.webdav.lib.Privilege;

public class TestAddPriv {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: TestAddPriv <url> <user> <priv> <grant>");
            System.exit(-1);
        }
        String url = args[0];
        String user = args[1];
        String priv = args[2];
        String action = args[3];
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String serverURL = (String)props.get("samserver");
        if (!url.startsWith("http://")) {
            url = serverURL + url;
        }
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url, dal);
        DSIAuthService authService = new DSIAuthService(dsi);
        Privilege privilege = null;
        if (priv.startsWith("read-acl")) {
            privilege = Privilege.READ_ACL;
        } else if (priv.startsWith("read")) {
            privilege = Privilege.READ;
        } else if (priv.startsWith("write-acl")) {
            privilege = Privilege.WRITE_ACL;
        } else if (priv.startsWith("w")) {
            privilege = Privilege.WRITE;
        } else if (priv.startsWith("a")) {
            privilege = Privilege.ALL;
        } else {
            System.out.println("UNRECOGNIZABLE PRIVILEGE: " + privilege);
            return;
        }
        try {
            dsi.getMetaData(new NSProperty("DAV::resourcetype"));
            if (action.equals("add")) {
                System.out.println("-----------------");
                System.out.println("adding privilege ");
                System.out.println("-----------------");
                authService.addPrivilege(privilege, url, user);
            } else if (action.equals("remove")) {
                System.out.println("-----------------");
                System.out.println("removing privilege ");
                System.out.println("-----------------");
                authService.removePrivilege(privilege, url, user);
            } else if (action.equals("deny")) {
                System.out.println("-----------------");
                System.out.println("denying privilege ");
                System.out.println("-----------------");
                authService.denyPrivilege(privilege, url, user);
            }
            System.out.println("-----------------");
            System.out.println("Finished");
            System.out.println("-----------------");
        }
        catch (AccessException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception other) {
            System.out.println("Other: " + other.getMessage());
        }
        System.exit(0);
    }
}

