/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Hashtable;
import java.util.Vector;

public class TestSearchList {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Does a search - edit code to change search...");
            System.err.println("Usage: TestSearchList <url> ");
            System.exit(-1);
        }
        String url2 = args[0];
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url2, dal);
        Vector<NSProperty> propVec = new Vector<NSProperty>();
        propVec.add(new NSProperty("DAV::displayname"));
        propVec.add(new NSProperty("http://purl.org/dc/elements/1.1/:title"));
        propVec.add(new NSProperty("DAV::getlastmodified"));
        propVec.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:curationStatus"));
        propVec.add(new NSProperty("http://purl.org/dc/elements/1.1/:format"));
        propVec.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:effectivePotentialsLink"));
        propVec.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:hasElements"));
        propVec.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionPI"));
        propVec.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributName"));
        Vector<NSProperty> where = new Vector<NSProperty>();
        where.add(new NSProperty("http://purl.org/dc/elements/1.1/:format"));
        try {
            String searchVal = "gaussian";
            Hashtable props = dsi.searchMetaData(propVec, where, Integer.MAX_VALUE, searchVal);
            if (props.size() != 0) {
                System.out.println("#urls " + props.size());
                for (String url2 : props.keySet()) {
                    System.out.println("\nurl " + url2);
                    Hashtable propcoll = (Hashtable)props.get(url2);
                    System.out.println("property size" + propcoll.size());
                    for (NSProperty ns : propcoll.keySet()) {
                        DSIProperty prop = (DSIProperty)propcoll.get(ns);
                        String propVal = prop.getPropertyAsString().trim();
                        if (propVal.length() == 0) {
                            propVal = prop.getPropertyAsXMLString(true).trim();
                        }
                        System.out.println(prop.getPropertyKey() + "=" + propVal);
                    }
                }
            } else {
                System.out.println("search is nullXXX");
            }
        }
        catch (StatusException ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(LoggerUtils.getStackTrace(e));
        }
        System.exit(0);
    }
}

