% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{reindex_dend}
\alias{reindex_dend}
\title{Reindexing a pruned dendrogram}
\usage{
reindex_dend(dend)
}
\arguments{
\item{dend}{dendrogram object}
}
\value{
A \code{dendrogram} object with the leaf reindexed
}
\description{
\code{prune_leaf} does not update leaf indices as it prune
leaves. As a result, some leaves of the pruned dendrogram may have leaf
indeices larger than the number of leaves in the pruned dendrogram, which may
cause errors in downstream functions such as \code{as.hclust}.

This function re-indexes the leaves such that the leaf indices are no larger
than the total number of leaves.
}
\examples{
hc <- hclust(dist(USArrests[1:5,]), "ave")
dend <- as.dendrogram(hc)

dend_pruned <- prune(dend , c("Alaska", "California"), reindex_dend = FALSE )

## A leave have an index larger than the number of leaves:
unlist (dend_pruned)
# [1] 4 3 1
#' 
dend_pruned_reindexed <- reindex_dend (dend_pruned)

## All leaf indices are no larger than the number of leaves:
unlist (dend_pruned_reindexed)
# [1] 3 2 1

## The dendrograms are equal:
all.equal (dend_pruned, dend_pruned_reindexed)
# TRUE


}
