/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/

/*Image2HeaderVersion: 3.5.2*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8192E_SUPPORT == 1)
static boolean
check_positive(
	struct dm_struct *dm,
	const u32	condition1,
	const u32	condition2,
	const u32	condition3,
	const u32	condition4
)
{
	u8	_board_type = ((dm->board_type & BIT(4)) >> 4) << 0 | /* _GLNA*/
			((dm->board_type & BIT(3)) >> 3) << 1 | /* _GPA*/
			((dm->board_type & BIT(7)) >> 7) << 2 | /* _ALNA*/
			((dm->board_type & BIT(6)) >> 6) << 3 | /* _APA */
			((dm->board_type & BIT(2)) >> 2) << 4 | /* _BT*/
			((dm->board_type & BIT(1)) >> 1) << 5 | /* _NGFF*/
			((dm->board_type & BIT(5)) >> 5) << 6;  /* _TRSWT*/

	u32	cond1 = condition1, cond2 = condition2, cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para = (dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;
	u8	pkg_type_for_para = (dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			_board_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
	"===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
	"===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
	"	(Platform, Interface) = (0x%X, 0x%X)\n", dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT,
	"	(Board, Package) = (0x%X, 0x%X)\n", dm->board_type, dm->package_type);


	/*============== value Defined Check ===============*/
	/*QFN type [15:12] and cut version [27:24] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x00FF0FFF;
	driver1 &= 0x00FF0FFF;

	if ((cond1 & driver1) == cond1) {
		u32	bit_mask = 0;

		if ((cond1 & 0x0F) == 0) /* board_type is DONTCARE*/
			return true;

		if ((cond1 & BIT(0)) != 0) /*GLNA*/
			bit_mask |= 0x000000FF;
		if ((cond1 & BIT(1)) != 0) /*GPA*/
			bit_mask |= 0x0000FF00;
		if ((cond1 & BIT(2)) != 0) /*ALNA*/
			bit_mask |= 0x00FF0000;
		if ((cond1 & BIT(3)) != 0) /*APA*/
			bit_mask |= 0xFF000000;

		if (((cond2 & bit_mask) == (driver2 & bit_mask)) && ((cond4 & bit_mask) == (driver4 & bit_mask)))  /* board_type of each RF path is matched*/
			return true;
		else
			return false;
	} else
		return false;
}

/******************************************************************************
*                           agc_tab.TXT
******************************************************************************/

u32 array_mp_8192e_agc_tab[] = {
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFF000001,
		0xC78, 0xFF010001,
		0xC78, 0xFE020001,
		0xC78, 0xFD030001,
		0xC78, 0xFC040001,
		0xC78, 0xFB050001,
		0xC78, 0xFA060001,
		0xC78, 0xF9070001,
		0xC78, 0xF8080001,
		0xC78, 0xF7090001,
		0xC78, 0xF60A0001,
		0xC78, 0xF50B0001,
		0xC78, 0xF40C0001,
		0xC78, 0xF30D0001,
		0xC78, 0xF20E0001,
		0xC78, 0xF10F0001,
		0xC78, 0xF0100001,
		0xC78, 0xEF110001,
		0xC78, 0xEE120001,
		0xC78, 0xED130001,
		0xC78, 0xEC140001,
		0xC78, 0xEB150001,
		0xC78, 0xEA160001,
		0xC78, 0xE9170001,
		0xC78, 0xE8180001,
		0xC78, 0xC9190001,
		0xC78, 0xC81A0001,
		0xC78, 0xC71B0001,
		0xC78, 0xC61C0001,
		0xC78, 0xC51D0001,
		0xC78, 0xC41E0001,
		0xC78, 0xC31F0001,
		0xC78, 0x05200001,
		0xC78, 0x04210001,
		0xC78, 0x03220001,
		0xC78, 0x02230001,
		0xC78, 0xA8240001,
		0xC78, 0xA7250001,
		0xC78, 0xA6260001,
		0xC78, 0xA5270001,
		0xC78, 0x27280001,
		0xC78, 0x26290001,
		0xC78, 0x252A0001,
		0xC78, 0x242B0001,
		0xC78, 0x232C0001,
		0xC78, 0x222D0001,
		0xC78, 0x662E0001,
		0xC78, 0x652F0001,
		0xC78, 0x64300001,
		0xC78, 0x63310001,
		0xC78, 0x62320001,
		0xC78, 0x61330001,
		0xC78, 0x46340001,
		0xC78, 0x45350001,
		0xC78, 0x44360001,
		0xC78, 0x43370001,
		0xC78, 0x42380001,
		0xC78, 0x41390001,
		0xC78, 0x403A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFB000001,
		0xC78, 0xFB010001,
		0xC78, 0xFA020001,
		0xC78, 0xF9030001,
		0xC78, 0xF8040001,
		0xC78, 0xF7050001,
		0xC78, 0xF6060001,
		0xC78, 0xF5070001,
		0xC78, 0xF4080001,
		0xC78, 0xF3090001,
		0xC78, 0xF20A0001,
		0xC78, 0xF10B0001,
		0xC78, 0xF00C0001,
		0xC78, 0xEF0D0001,
		0xC78, 0xEE0E0001,
		0xC78, 0xED0F0001,
		0xC78, 0xEC100001,
		0xC78, 0xEB110001,
		0xC78, 0xEA120001,
		0xC78, 0xE9130001,
		0xC78, 0xE8140001,
		0xC78, 0xE7150001,
		0xC78, 0xE6160001,
		0xC78, 0xE5170001,
		0xC78, 0xE4180001,
		0xC78, 0xE3190001,
		0xC78, 0xE21A0001,
		0xC78, 0xE11B0001,
		0xC78, 0x8A1C0001,
		0xC78, 0x891D0001,
		0xC78, 0x881E0001,
		0xC78, 0x871F0001,
		0xC78, 0x86200001,
		0xC78, 0x85210001,
		0xC78, 0x84220001,
		0xC78, 0x83230001,
		0xC78, 0x82240001,
		0xC78, 0x6A250001,
		0xC78, 0x69260001,
		0xC78, 0x68270001,
		0xC78, 0x67280001,
		0xC78, 0x66290001,
		0xC78, 0x652A0001,
		0xC78, 0x642B0001,
		0xC78, 0x632C0001,
		0xC78, 0x622D0001,
		0xC78, 0x612E0001,
		0xC78, 0x602F0001,
		0xC78, 0x47300001,
		0xC78, 0x46310001,
		0xC78, 0x45320001,
		0xC78, 0x44330001,
		0xC78, 0x43340001,
		0xC78, 0x42350001,
		0xC78, 0x41360001,
		0xC78, 0x40370001,
		0xC78, 0x40380001,
		0xC78, 0x40390001,
		0xC78, 0x403A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0xC78, 0xFB000001,
		0xC78, 0xFB010001,
		0xC78, 0xFB020001,
		0xC78, 0xFB030001,
		0xC78, 0xFA040001,
		0xC78, 0xF9050001,
		0xC78, 0xF8060001,
		0xC78, 0xF7070001,
		0xC78, 0xF6080001,
		0xC78, 0xF5090001,
		0xC78, 0xF40A0001,
		0xC78, 0xF30B0001,
		0xC78, 0xF20C0001,
		0xC78, 0xF10D0001,
		0xC78, 0xF00E0001,
		0xC78, 0xEF0F0001,
		0xC78, 0xEE100001,
		0xC78, 0xED110001,
		0xC78, 0xEC120001,
		0xC78, 0xEB130001,
		0xC78, 0xEA140001,
		0xC78, 0xE9150001,
		0xC78, 0xE8160001,
		0xC78, 0xE7170001,
		0xC78, 0xE6180001,
		0xC78, 0xE5190001,
		0xC78, 0xE41A0001,
		0xC78, 0xE31B0001,
		0xC78, 0xE21C0001,
		0xC78, 0xE11D0001,
		0xC78, 0x8A1E0001,
		0xC78, 0x891F0001,
		0xC78, 0x88200001,
		0xC78, 0x87210001,
		0xC78, 0x86220001,
		0xC78, 0x85230001,
		0xC78, 0x84240001,
		0xC78, 0x83250001,
		0xC78, 0x82260001,
		0xC78, 0x6A270001,
		0xC78, 0x69280001,
		0xC78, 0x68290001,
		0xC78, 0x672A0001,
		0xC78, 0x662B0001,
		0xC78, 0x652C0001,
		0xC78, 0x642D0001,
		0xC78, 0x632E0001,
		0xC78, 0x622F0001,
		0xC78, 0x61300001,
		0xC78, 0x60310001,
		0xC78, 0x47320001,
		0xC78, 0x46330001,
		0xC78, 0x45340001,
		0xC78, 0x44350001,
		0xC78, 0x43360001,
		0xC78, 0x42370001,
		0xC78, 0x41380001,
		0xC78, 0x40390001,
		0xC78, 0x403A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0xC78, 0xFB000001,
		0xC78, 0xFB010001,
		0xC78, 0xFB020001,
		0xC78, 0xFB030001,
		0xC78, 0xFB040001,
		0xC78, 0xFA050001,
		0xC78, 0xF9060001,
		0xC78, 0xF8070001,
		0xC78, 0xF7080001,
		0xC78, 0xF6090001,
		0xC78, 0xF50A0001,
		0xC78, 0xF40B0001,
		0xC78, 0xF30C0001,
		0xC78, 0xF20D0001,
		0xC78, 0xF10E0001,
		0xC78, 0xF00F0001,
		0xC78, 0xEF100001,
		0xC78, 0xEE110001,
		0xC78, 0xED120001,
		0xC78, 0xEC130001,
		0xC78, 0xEB140001,
		0xC78, 0xEA150001,
		0xC78, 0xE9160001,
		0xC78, 0xE8170001,
		0xC78, 0xE7180001,
		0xC78, 0xE6190001,
		0xC78, 0xE51A0001,
		0xC78, 0xE41B0001,
		0xC78, 0xE31C0001,
		0xC78, 0xE21D0001,
		0xC78, 0xE11E0001,
		0xC78, 0x8A1F0001,
		0xC78, 0x89200001,
		0xC78, 0x88210001,
		0xC78, 0x87220001,
		0xC78, 0x86230001,
		0xC78, 0x85240001,
		0xC78, 0x84250001,
		0xC78, 0x83260001,
		0xC78, 0x82270001,
		0xC78, 0x6A280001,
		0xC78, 0x69290001,
		0xC78, 0x682A0001,
		0xC78, 0x672B0001,
		0xC78, 0x662C0001,
		0xC78, 0x652D0001,
		0xC78, 0x642E0001,
		0xC78, 0x632F0001,
		0xC78, 0x62300001,
		0xC78, 0x61310001,
		0xC78, 0x60320001,
		0xC78, 0x47330001,
		0xC78, 0x46340001,
		0xC78, 0x45350001,
		0xC78, 0x44360001,
		0xC78, 0x43370001,
		0xC78, 0x42380001,
		0xC78, 0x41390001,
		0xC78, 0x403A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0xC78, 0xFB000001,
		0xC78, 0xFB010001,
		0xC78, 0xFB020001,
		0xC78, 0xFB030001,
		0xC78, 0xFB040001,
		0xC78, 0xFB050001,
		0xC78, 0xFA060001,
		0xC78, 0xF9070001,
		0xC78, 0xF8080001,
		0xC78, 0xF7090001,
		0xC78, 0xF60A0001,
		0xC78, 0xF50B0001,
		0xC78, 0xF40C0001,
		0xC78, 0xF30D0001,
		0xC78, 0xF20E0001,
		0xC78, 0xF10F0001,
		0xC78, 0xF0100001,
		0xC78, 0xEF110001,
		0xC78, 0xEE120001,
		0xC78, 0xED130001,
		0xC78, 0xEC140001,
		0xC78, 0xEB150001,
		0xC78, 0xEA160001,
		0xC78, 0xE9170001,
		0xC78, 0xE8180001,
		0xC78, 0xE7190001,
		0xC78, 0xE61A0001,
		0xC78, 0xE51B0001,
		0xC78, 0xE41C0001,
		0xC78, 0xE31D0001,
		0xC78, 0xE21E0001,
		0xC78, 0xE11F0001,
		0xC78, 0x8A200001,
		0xC78, 0x89210001,
		0xC78, 0x88220001,
		0xC78, 0x87230001,
		0xC78, 0x86240001,
		0xC78, 0x85250001,
		0xC78, 0x84260001,
		0xC78, 0x83270001,
		0xC78, 0x82280001,
		0xC78, 0x6A290001,
		0xC78, 0x692A0001,
		0xC78, 0x682B0001,
		0xC78, 0x672C0001,
		0xC78, 0x662D0001,
		0xC78, 0x652E0001,
		0xC78, 0x642F0001,
		0xC78, 0x63300001,
		0xC78, 0x62310001,
		0xC78, 0x61320001,
		0xC78, 0x60330001,
		0xC78, 0x47340001,
		0xC78, 0x46350001,
		0xC78, 0x45360001,
		0xC78, 0x44370001,
		0xC78, 0x43380001,
		0xC78, 0x42390001,
		0xC78, 0x413A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFB000001,
		0xC78, 0xFB010001,
		0xC78, 0xFB020001,
		0xC78, 0xFB030001,
		0xC78, 0xFB040001,
		0xC78, 0xFB050001,
		0xC78, 0xFB060001,
		0xC78, 0xFB070001,
		0xC78, 0xFA080001,
		0xC78, 0xF9090001,
		0xC78, 0xF80A0001,
		0xC78, 0xF70B0001,
		0xC78, 0xF60C0001,
		0xC78, 0xF50D0001,
		0xC78, 0xF40E0001,
		0xC78, 0xF30F0001,
		0xC78, 0xF2100001,
		0xC78, 0xF1110001,
		0xC78, 0xF0120001,
		0xC78, 0xEF130001,
		0xC78, 0xEE140001,
		0xC78, 0xED150001,
		0xC78, 0xEC160001,
		0xC78, 0xEB170001,
		0xC78, 0xEA180001,
		0xC78, 0xE9190001,
		0xC78, 0xC81A0001,
		0xC78, 0xC71B0001,
		0xC78, 0xC61C0001,
		0xC78, 0x071D0001,
		0xC78, 0x061E0001,
		0xC78, 0x051F0001,
		0xC78, 0x04200001,
		0xC78, 0x03210001,
		0xC78, 0xAA220001,
		0xC78, 0xA9230001,
		0xC78, 0xA8240001,
		0xC78, 0xA7250001,
		0xC78, 0xA6260001,
		0xC78, 0x85270001,
		0xC78, 0x84280001,
		0xC78, 0x83290001,
		0xC78, 0x252A0001,
		0xC78, 0x242B0001,
		0xC78, 0x232C0001,
		0xC78, 0x222D0001,
		0xC78, 0x672E0001,
		0xC78, 0x662F0001,
		0xC78, 0x65300001,
		0xC78, 0x64310001,
		0xC78, 0x63320001,
		0xC78, 0x62330001,
		0xC78, 0x61340001,
		0xC78, 0x45350001,
		0xC78, 0x44360001,
		0xC78, 0x43370001,
		0xC78, 0x42380001,
		0xC78, 0x41390001,
		0xC78, 0x403A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0xA0000000,	0x00000000,
		0xC78, 0xFF000001,
		0xC78, 0xFF010001,
		0xC78, 0xFE020001,
		0xC78, 0xFD030001,
		0xC78, 0xFC040001,
		0xC78, 0xFB050001,
		0xC78, 0xFA060001,
		0xC78, 0xF9070001,
		0xC78, 0xF8080001,
		0xC78, 0xF7090001,
		0xC78, 0xF60A0001,
		0xC78, 0xF50B0001,
		0xC78, 0xF40C0001,
		0xC78, 0xF30D0001,
		0xC78, 0xF20E0001,
		0xC78, 0xF10F0001,
		0xC78, 0xF0100001,
		0xC78, 0xEF110001,
		0xC78, 0xEE120001,
		0xC78, 0xED130001,
		0xC78, 0xEC140001,
		0xC78, 0xEB150001,
		0xC78, 0xEA160001,
		0xC78, 0xE9170001,
		0xC78, 0xE8180001,
		0xC78, 0xC9190001,
		0xC78, 0xC81A0001,
		0xC78, 0xC71B0001,
		0xC78, 0xC61C0001,
		0xC78, 0xC51D0001,
		0xC78, 0xC41E0001,
		0xC78, 0xC31F0001,
		0xC78, 0x05200001,
		0xC78, 0x04210001,
		0xC78, 0x03220001,
		0xC78, 0x02230001,
		0xC78, 0xA8240001,
		0xC78, 0xA7250001,
		0xC78, 0xA6260001,
		0xC78, 0xA5270001,
		0xC78, 0x27280001,
		0xC78, 0x26290001,
		0xC78, 0x252A0001,
		0xC78, 0x242B0001,
		0xC78, 0x232C0001,
		0xC78, 0x222D0001,
		0xC78, 0x662E0001,
		0xC78, 0x652F0001,
		0xC78, 0x64300001,
		0xC78, 0x63310001,
		0xC78, 0x62320001,
		0xC78, 0x61330001,
		0xC78, 0x46340001,
		0xC78, 0x45350001,
		0xC78, 0x44360001,
		0xC78, 0x43370001,
		0xC78, 0x42380001,
		0xC78, 0x41390001,
		0xC78, 0x403A0001,
		0xC78, 0x403B0001,
		0xC78, 0x403C0001,
		0xC78, 0x403D0001,
		0xC78, 0x403E0001,
		0xC78, 0x403F0001,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFB400001,
		0xC78, 0xFB410001,
		0xC78, 0xFB420001,
		0xC78, 0xFB430001,
		0xC78, 0xFB440001,
		0xC78, 0xFB450001,
		0xC78, 0xFB460001,
		0xC78, 0xFA470001,
		0xC78, 0xF9480001,
		0xC78, 0xF8490001,
		0xC78, 0xF74A0001,
		0xC78, 0xF64B0001,
		0xC78, 0xF54C0001,
		0xC78, 0xF44D0001,
		0xC78, 0xF34E0001,
		0xC78, 0xF24F0001,
		0xC78, 0xF1500001,
		0xC78, 0xF0510001,
		0xC78, 0xEF520001,
		0xC78, 0xEE530001,
		0xC78, 0xED540001,
		0xC78, 0xEC550001,
		0xC78, 0xEB560001,
		0xC78, 0xEA570001,
		0xC78, 0xE9580001,
		0xC78, 0xE8590001,
		0xC78, 0xE75A0001,
		0xC78, 0xE65B0001,
		0xC78, 0xE55C0001,
		0xC78, 0xE45D0001,
		0xC78, 0xE35E0001,
		0xC78, 0xE25F0001,
		0xC78, 0xE1600001,
		0xC78, 0x8A610001,
		0xC78, 0x89620001,
		0xC78, 0x88630001,
		0xC78, 0x87640001,
		0xC78, 0x86650001,
		0xC78, 0x85660001,
		0xC78, 0x84670001,
		0xC78, 0x83680001,
		0xC78, 0x82690001,
		0xC78, 0x6B6A0001,
		0xC78, 0x6A6B0001,
		0xC78, 0x696C0001,
		0xC78, 0x686D0001,
		0xC78, 0x676E0001,
		0xC78, 0x666F0001,
		0xC78, 0x65700001,
		0xC78, 0x64710001,
		0xC78, 0x63720001,
		0xC78, 0x62730001,
		0xC78, 0x61740001,
		0xC78, 0x49750001,
		0xC78, 0x48760001,
		0xC78, 0x47770001,
		0xC78, 0x46780001,
		0xC78, 0x45790001,
		0xC78, 0x447A0001,
		0xC78, 0x437B0001,
		0xC78, 0x427C0001,
		0xC78, 0x417D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040220,
		0xC58, 0x00000220,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFE400001,
		0xC78, 0xFD410001,
		0xC78, 0xFC420001,
		0xC78, 0xFB430001,
		0xC78, 0xFA440001,
		0xC78, 0xF9450001,
		0xC78, 0xF8460001,
		0xC78, 0xF7470001,
		0xC78, 0xF6480001,
		0xC78, 0xF5490001,
		0xC78, 0xF44A0001,
		0xC78, 0xF34B0001,
		0xC78, 0xF24C0001,
		0xC78, 0xF14D0001,
		0xC78, 0xF04E0001,
		0xC78, 0xEF4F0001,
		0xC78, 0xEE500001,
		0xC78, 0xED510001,
		0xC78, 0xEC520001,
		0xC78, 0xEB530001,
		0xC78, 0xEA540001,
		0xC78, 0xE9550001,
		0xC78, 0xE8560001,
		0xC78, 0xE7570001,
		0xC78, 0xE6580001,
		0xC78, 0xE5590001,
		0xC78, 0xE45A0001,
		0xC78, 0xE35B0001,
		0xC78, 0x885C0001,
		0xC78, 0x875D0001,
		0xC78, 0xAA5E0001,
		0xC78, 0xA95F0001,
		0xC78, 0xA8600001,
		0xC78, 0xA7610001,
		0xC78, 0xA6620001,
		0xC78, 0xA5630001,
		0xC78, 0x66640001,
		0xC78, 0x65650001,
		0xC78, 0x64660001,
		0xC78, 0x63670001,
		0xC78, 0x62680001,
		0xC78, 0x49690001,
		0xC78, 0x486A0001,
		0xC78, 0x476B0001,
		0xC78, 0x466C0001,
		0xC78, 0x456D0001,
		0xC78, 0x446E0001,
		0xC78, 0x436F0001,
		0xC78, 0x42700001,
		0xC78, 0x41710001,
		0xC78, 0x40720001,
		0xC78, 0x40730001,
		0xC78, 0x40740001,
		0xC78, 0x40750001,
		0xC78, 0x40760001,
		0xC78, 0x40770001,
		0xC78, 0x40780001,
		0xC78, 0x40790001,
		0xC78, 0x407A0001,
		0xC78, 0x407B0001,
		0xC78, 0x407C0001,
		0xC78, 0x407D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040220,
		0xC58, 0x00000220,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0xC78, 0xFE400001,
		0xC78, 0xFE410001,
		0xC78, 0xFE420001,
		0xC78, 0xFD430001,
		0xC78, 0xFC440001,
		0xC78, 0xFB450001,
		0xC78, 0xFA460001,
		0xC78, 0xF9470001,
		0xC78, 0xF8480001,
		0xC78, 0xF7490001,
		0xC78, 0xF64A0001,
		0xC78, 0xF54B0001,
		0xC78, 0xF44C0001,
		0xC78, 0xF34D0001,
		0xC78, 0xF24E0001,
		0xC78, 0xF14F0001,
		0xC78, 0xF0500001,
		0xC78, 0xEF510001,
		0xC78, 0xEE520001,
		0xC78, 0xED530001,
		0xC78, 0xEC540001,
		0xC78, 0xEB550001,
		0xC78, 0xEA560001,
		0xC78, 0xE9570001,
		0xC78, 0xE8580001,
		0xC78, 0xE7590001,
		0xC78, 0xE65A0001,
		0xC78, 0xE55B0001,
		0xC78, 0xE45C0001,
		0xC78, 0xE35D0001,
		0xC78, 0x885E0001,
		0xC78, 0x875F0001,
		0xC78, 0xAA600001,
		0xC78, 0xA9610001,
		0xC78, 0xA8620001,
		0xC78, 0xA7630001,
		0xC78, 0xA6640001,
		0xC78, 0xA5650001,
		0xC78, 0x66660001,
		0xC78, 0x65670001,
		0xC78, 0x64680001,
		0xC78, 0x63690001,
		0xC78, 0x626A0001,
		0xC78, 0x496B0001,
		0xC78, 0x486C0001,
		0xC78, 0x476D0001,
		0xC78, 0x466E0001,
		0xC78, 0x456F0001,
		0xC78, 0x44700001,
		0xC78, 0x43710001,
		0xC78, 0x42720001,
		0xC78, 0x41730001,
		0xC78, 0x40740001,
		0xC78, 0x40750001,
		0xC78, 0x40760001,
		0xC78, 0x40770001,
		0xC78, 0x40780001,
		0xC78, 0x40790001,
		0xC78, 0x407A0001,
		0xC78, 0x407B0001,
		0xC78, 0x407C0001,
		0xC78, 0x407D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040220,
		0xC58, 0x00000220,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0xC78, 0xFE400001,
		0xC78, 0xFE410001,
		0xC78, 0xFE420001,
		0xC78, 0xFE430001,
		0xC78, 0xFD440001,
		0xC78, 0xFC450001,
		0xC78, 0xFB460001,
		0xC78, 0xFA470001,
		0xC78, 0xF9480001,
		0xC78, 0xF8490001,
		0xC78, 0xF74A0001,
		0xC78, 0xF64B0001,
		0xC78, 0xF54C0001,
		0xC78, 0xF44D0001,
		0xC78, 0xF34E0001,
		0xC78, 0xF24F0001,
		0xC78, 0xF1500001,
		0xC78, 0xF0510001,
		0xC78, 0xEF520001,
		0xC78, 0xEE530001,
		0xC78, 0xED540001,
		0xC78, 0xEC550001,
		0xC78, 0xEB560001,
		0xC78, 0xEA570001,
		0xC78, 0xE9580001,
		0xC78, 0xE8590001,
		0xC78, 0xE75A0001,
		0xC78, 0xE65B0001,
		0xC78, 0xE55C0001,
		0xC78, 0xE45D0001,
		0xC78, 0xE35E0001,
		0xC78, 0x885F0001,
		0xC78, 0x87600001,
		0xC78, 0xAA610001,
		0xC78, 0xA9620001,
		0xC78, 0xA8630001,
		0xC78, 0xA7640001,
		0xC78, 0xA6650001,
		0xC78, 0xA5660001,
		0xC78, 0x66670001,
		0xC78, 0x65680001,
		0xC78, 0x64690001,
		0xC78, 0x636A0001,
		0xC78, 0x626B0001,
		0xC78, 0x496C0001,
		0xC78, 0x486D0001,
		0xC78, 0x476E0001,
		0xC78, 0x466F0001,
		0xC78, 0x45700001,
		0xC78, 0x44710001,
		0xC78, 0x43720001,
		0xC78, 0x42730001,
		0xC78, 0x41740001,
		0xC78, 0x40750001,
		0xC78, 0x40760001,
		0xC78, 0x40770001,
		0xC78, 0x40780001,
		0xC78, 0x40790001,
		0xC78, 0x407A0001,
		0xC78, 0x407B0001,
		0xC78, 0x407C0001,
		0xC78, 0x407D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040220,
		0xC58, 0x00000220,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0xC78, 0xFE400001,
		0xC78, 0xFE410001,
		0xC78, 0xFE420001,
		0xC78, 0xFE430001,
		0xC78, 0xFE440001,
		0xC78, 0xFD450001,
		0xC78, 0xFC460001,
		0xC78, 0xFB470001,
		0xC78, 0xFA480001,
		0xC78, 0xF9490001,
		0xC78, 0xF84A0001,
		0xC78, 0xF74B0001,
		0xC78, 0xF64C0001,
		0xC78, 0xF54D0001,
		0xC78, 0xF44E0001,
		0xC78, 0xF34F0001,
		0xC78, 0xF2500001,
		0xC78, 0xF1510001,
		0xC78, 0xF0520001,
		0xC78, 0xEF530001,
		0xC78, 0xEE540001,
		0xC78, 0xED550001,
		0xC78, 0xEC560001,
		0xC78, 0xEB570001,
		0xC78, 0xEA580001,
		0xC78, 0x09590001,
		0xC78, 0x085A0001,
		0xC78, 0x075B0001,
		0xC78, 0x065C0001,
		0xC78, 0x055D0001,
		0xC78, 0x045E0001,
		0xC78, 0x035F0001,
		0xC78, 0x29600001,
		0xC78, 0x28610001,
		0xC78, 0x27620001,
		0xC78, 0x26630001,
		0xC78, 0x25640001,
		0xC78, 0x24650001,
		0xC78, 0x23660001,
		0xC78, 0x68670001,
		0xC78, 0x67680001,
		0xC78, 0x66690001,
		0xC78, 0x656A0001,
		0xC78, 0x646B0001,
		0xC78, 0x636C0001,
		0xC78, 0x626D0001,
		0xC78, 0x496E0001,
		0xC78, 0x486F0001,
		0xC78, 0x47700001,
		0xC78, 0x46710001,
		0xC78, 0x45720001,
		0xC78, 0x44730001,
		0xC78, 0x43740001,
		0xC78, 0x42750001,
		0xC78, 0x41760001,
		0xC78, 0x40770001,
		0xC78, 0x40780001,
		0xC78, 0x40790001,
		0xC78, 0x407A0001,
		0xC78, 0x407B0001,
		0xC78, 0x407C0001,
		0xC78, 0x407D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040220,
		0xC58, 0x00000220,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFB400001,
		0xC78, 0xFB410001,
		0xC78, 0xFB420001,
		0xC78, 0xFB430001,
		0xC78, 0xFB440001,
		0xC78, 0xFB450001,
		0xC78, 0xFA460001,
		0xC78, 0xF9470001,
		0xC78, 0xF8480001,
		0xC78, 0xF7490001,
		0xC78, 0xF64A0001,
		0xC78, 0xF54B0001,
		0xC78, 0xF44C0001,
		0xC78, 0xF34D0001,
		0xC78, 0xF24E0001,
		0xC78, 0xF14F0001,
		0xC78, 0xF0500001,
		0xC78, 0xEF510001,
		0xC78, 0xEE520001,
		0xC78, 0xED530001,
		0xC78, 0xEC540001,
		0xC78, 0xEB550001,
		0xC78, 0xEA560001,
		0xC78, 0xE9570001,
		0xC78, 0xE8580001,
		0xC78, 0xE7590001,
		0xC78, 0xE65A0001,
		0xC78, 0xE55B0001,
		0xC78, 0xE45C0001,
		0xC78, 0xE35D0001,
		0xC78, 0xE25E0001,
		0xC78, 0xE15F0001,
		0xC78, 0x8A600001,
		0xC78, 0x89610001,
		0xC78, 0x88620001,
		0xC78, 0x87630001,
		0xC78, 0x86640001,
		0xC78, 0x85650001,
		0xC78, 0x84660001,
		0xC78, 0x83670001,
		0xC78, 0x82680001,
		0xC78, 0x6B690001,
		0xC78, 0x6A6A0001,
		0xC78, 0x696B0001,
		0xC78, 0x686C0001,
		0xC78, 0x676D0001,
		0xC78, 0x666E0001,
		0xC78, 0x656F0001,
		0xC78, 0x64700001,
		0xC78, 0x63710001,
		0xC78, 0x62720001,
		0xC78, 0x61730001,
		0xC78, 0x49740001,
		0xC78, 0x48750001,
		0xC78, 0x47760001,
		0xC78, 0x46770001,
		0xC78, 0x45780001,
		0xC78, 0x44790001,
		0xC78, 0x437A0001,
		0xC78, 0x427B0001,
		0xC78, 0x417C0001,
		0xC78, 0x407D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040020,
		0xC58, 0x00000020,
	0xA0000000,	0x00000000,
		0xC78, 0xFB400001,
		0xC78, 0xFB410001,
		0xC78, 0xFB420001,
		0xC78, 0xFB430001,
		0xC78, 0xFB440001,
		0xC78, 0xFB450001,
		0xC78, 0xFB460001,
		0xC78, 0xFA470001,
		0xC78, 0xF9480001,
		0xC78, 0xF8490001,
		0xC78, 0xF74A0001,
		0xC78, 0xF64B0001,
		0xC78, 0xF54C0001,
		0xC78, 0xF44D0001,
		0xC78, 0xF34E0001,
		0xC78, 0xF24F0001,
		0xC78, 0xF1500001,
		0xC78, 0xF0510001,
		0xC78, 0xEF520001,
		0xC78, 0xEE530001,
		0xC78, 0xED540001,
		0xC78, 0xEC550001,
		0xC78, 0xEB560001,
		0xC78, 0xEA570001,
		0xC78, 0xE9580001,
		0xC78, 0xE8590001,
		0xC78, 0xE75A0001,
		0xC78, 0xE65B0001,
		0xC78, 0xE55C0001,
		0xC78, 0xE45D0001,
		0xC78, 0xE35E0001,
		0xC78, 0xE25F0001,
		0xC78, 0xE1600001,
		0xC78, 0x8A610001,
		0xC78, 0x89620001,
		0xC78, 0x88630001,
		0xC78, 0x87640001,
		0xC78, 0x86650001,
		0xC78, 0x85660001,
		0xC78, 0x84670001,
		0xC78, 0x83680001,
		0xC78, 0x82690001,
		0xC78, 0x6B6A0001,
		0xC78, 0x6A6B0001,
		0xC78, 0x696C0001,
		0xC78, 0x686D0001,
		0xC78, 0x676E0001,
		0xC78, 0x666F0001,
		0xC78, 0x65700001,
		0xC78, 0x64710001,
		0xC78, 0x63720001,
		0xC78, 0x62730001,
		0xC78, 0x61740001,
		0xC78, 0x49750001,
		0xC78, 0x48760001,
		0xC78, 0x47770001,
		0xC78, 0x46780001,
		0xC78, 0x45790001,
		0xC78, 0x447A0001,
		0xC78, 0x437B0001,
		0xC78, 0x427C0001,
		0xC78, 0x417D0001,
		0xC78, 0x407E0001,
		0xC78, 0x407F0001,
		0xC50, 0x00040020,
		0xC58, 0x00000020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8192e_agc_tab(
	struct	dm_struct *dm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8192e_agc_tab)/sizeof(u32);
	u32	*array = array_mp_8192e_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> odm_read_and_config_mp_8192e_agc_tab\n");

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT, "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(dm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8192e(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8192e_agc_tab(void)
{
		return 61;
}

/******************************************************************************
*                           phy_reg.TXT
******************************************************************************/

u32 array_mp_8192e_phy_reg[] = {
		0x800, 0x80040000,
		0x804, 0x00000003,
		0x808, 0x0000FC00,
		0x80C, 0x0000000A,
		0x810, 0x10001331,
		0x814, 0x020C3D10,
		0x818, 0x02220385,
		0x81C, 0x00000000,
		0x820, 0x01000100,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0x824, 0x00390004,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x824, 0x00390204,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x824, 0x00390004,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0x824, 0x00390004,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0x824, 0x00390004,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0x824, 0x00390004,
	0xA0000000,	0x00000000,
		0x824, 0x00390204,
	0xB0000000,	0x00000000,
		0x828, 0x01000100,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x00390004,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x00390204,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x00390004,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0x82C, 0x00390004,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0x82C, 0x00390004,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0x82C, 0x00390004,
	0xA0000000,	0x00000000,
		0x82C, 0x00390204,
	0xB0000000,	0x00000000,
		0x830, 0x32323232,
		0x834, 0x30303030,
		0x838, 0x30303030,
		0x83C, 0x30303030,
		0x840, 0x00010000,
		0x844, 0x00010000,
		0x848, 0x28282828,
		0x84C, 0x28282828,
		0x850, 0x00000000,
		0x854, 0x00000000,
		0x858, 0x009A009A,
		0x85C, 0x01000014,
		0x860, 0x66F60000,
		0x864, 0x061F0000,
		0x868, 0x30303030,
		0x86C, 0x30303030,
		0x870, 0x00000000,
		0x874, 0x55004200,
		0x878, 0x08080808,
		0x87C, 0x00000000,
		0x880, 0xB0000C1C,
		0x884, 0x00000001,
		0x888, 0x00000000,
		0x88C, 0xCC0000C0,
		0x890, 0x00000800,
		0x894, 0xFFFFFFFE,
		0x898, 0x40302010,
		0x900, 0x00000000,
		0x904, 0x00000023,
		0x908, 0x00000000,
		0x90C, 0x81121313,
		0x910, 0x806C0001,
		0x914, 0x00000001,
		0x918, 0x00000000,
		0x91C, 0x00010000,
		0x924, 0x00000001,
		0x928, 0x00000000,
		0x92C, 0x00000000,
		0x930, 0x00000000,
		0x934, 0x00000000,
		0x938, 0x00000000,
		0x93C, 0x00000000,
		0x940, 0x00000000,
		0x944, 0x00000000,
		0x94C, 0x00000008,
		0xA00, 0x00D047C8,
		0xA04, 0x81FF800C,
		0xA08, 0x8C838300,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xA0C, 0x2E30120F,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xA0C, 0x2E68120F,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0xA0C, 0x2E30120F,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0xA0C, 0x2E30120F,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0xA0C, 0x2E30120F,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0xA0C, 0x2E30120F,
	0xA0000000,	0x00000000,
		0xA0C, 0x2E68120F,
	0xB0000000,	0x00000000,
		0xA10, 0x95009B78,
		0xA14, 0x1114D028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xA20, 0x12130000,
		0xA24, 0x060A0D10,
		0xA28, 0x00000103,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xA20, 0x12130000,
		0xA24, 0x060A0D10,
		0xA28, 0x00000103,
	0xA0000000,	0x00000000,
		0xA20, 0x1A1B0000,
		0xA24, 0x090E1317,
		0xA28, 0x00000204,
	0xB0000000,	0x00000000,
		0xA2C, 0x00D30000,
		0xA70, 0x101FFF80,
		0xA74, 0x00000007,
		0xA78, 0x00000900,
		0xA7C, 0x225B0606,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xA80, 0x21807531,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xA80, 0x218075B1,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0xA80, 0x21807531,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0xA80, 0x21807531,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0xA80, 0x21807531,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0xA80, 0x21807531,
	0xA0000000,	0x00000000,
		0xA80, 0x218075B1,
	0xB0000000,	0x00000000,
		0xB38, 0x00000000,
		0xC00, 0x48071D40,
		0xC04, 0x03A05633,
		0xC08, 0x000000E4,
		0xC0C, 0x6C6C6C6C,
		0xC10, 0x08800000,
		0xC14, 0x40000100,
		0xC18, 0x08800000,
		0xC1C, 0x40000100,
		0xC20, 0x00000000,
		0xC24, 0x00000000,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
		0xC30, 0x69E9AC47,
		0xC34, 0x469652AF,
		0xC38, 0x49795994,
		0xC3C, 0x0A97971C,
		0xC40, 0x1F7C403F,
		0xC44, 0x000100B7,
		0xC48, 0xEC020107,
		0xC4C, 0x007F037F,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0xA0000000,	0x00000000,
		0xC50, 0x00340020,
	0xB0000000,	0x00000000,
		0xC54, 0x0080801F,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90000001,	0x0000000a,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90000001,	0x0000000f,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0xA0000000,	0x00000000,
		0xC58, 0x00000020,
	0xB0000000,	0x00000000,
		0xC5C, 0x00248492,
		0xC60, 0x00000000,
		0xC64, 0x2112848B,
		0xC68, 0x47C00BFF,
		0xC6C, 0x00000036,
		0xC70, 0x00000600,
		0xC74, 0x02013269,
		0xC78, 0x0000001F,
		0xC7C, 0x00B91612,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x2D4000B5,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x2D4000B5,
	0xA0000000,	0x00000000,
		0xC80, 0x40000100,
	0xB0000000,	0x00000000,
		0xC84, 0x21F60000,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x2D4000B5,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x2D4000B5,
	0xA0000000,	0x00000000,
		0xC88, 0x40000100,
	0xB0000000,	0x00000000,
		0xC8C, 0xA0E40000,
		0xC90, 0x00121820,
		0xC94, 0x00000000,
		0xC98, 0x00121820,
		0xC9C, 0x00007F7F,
		0xCA0, 0x00000000,
		0xCA4, 0x000300A0,
		0xCA8, 0x00000000,
		0xCAC, 0x00000000,
		0xCB0, 0x00000000,
		0xCB4, 0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x28000000,
		0xCC0, 0x00000000,
		0xCC4, 0x00000000,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x64B22427,
		0xCDC, 0x00766932,
		0xCE0, 0x00222222,
		0xCE4, 0x00040000,
		0xCE8, 0x77644302,
		0xCEC, 0x2F97D40C,
		0xD00, 0x00080740,
		0xD04, 0x00020403,
		0xD08, 0x0000907F,
		0xD0C, 0x20010201,
		0xD10, 0xA0633333,
		0xD14, 0x3333BC43,
		0xD18, 0x7A8F5B6B,
		0xD1C, 0x0000007F,
		0xD2C, 0xCC979175,
		0xD30, 0x00000000,
		0xD34, 0x40608000,
		0xD38, 0x00000000,
		0xD3C, 0x00127353,
		0xD40, 0x00000000,
		0xD44, 0x00000000,
		0xD48, 0x00000000,
		0xD4C, 0x00000000,
		0xD50, 0x6437140A,
		0xD54, 0x00000000,
		0xD58, 0x00000282,
		0xD5C, 0x30032064,
		0xD60, 0x4653DA68,
		0xD64, 0x04518A3C,
		0xD68, 0x00002101,
		0xD6C, 0x2A201C16,
		0xD70, 0x1812362E,
		0xD74, 0x322C2220,
		0xD78, 0x000E3C24,
		0xD80, 0x01081008,
		0xD84, 0x00000800,
		0xD88, 0xF0B50000,
		0xE00, 0x30303030,
		0xE04, 0x30303030,
		0xE08, 0x03903030,
		0xE10, 0x30303030,
		0xE14, 0x30303030,
		0xE18, 0x30303030,
		0xE1C, 0x30303030,
		0xE28, 0x00000000,
		0xE30, 0x1000DC1F,
		0xE34, 0x10008C1F,
		0xE38, 0x02140102,
		0xE3C, 0x681604C2,
		0xE40, 0x01007C00,
		0xE44, 0x01004800,
		0xE48, 0xFB000000,
		0xE4C, 0x000028D1,
		0xE50, 0x1000DC1F,
		0xE54, 0x10008C1F,
		0xE58, 0x02140102,
		0xE5C, 0x28160D05,
		0xE60, 0x00000048,
		0xE68, 0x0FC05656,
		0xE6C, 0x03C09696,
		0xE70, 0x03C09696,
		0xE74, 0x0C005656,
		0xE78, 0x0C005656,
		0xE7C, 0x0C005656,
		0xE80, 0x0C005656,
		0xE84, 0x03C09696,
		0xE88, 0x0C005656,
		0xE8C, 0x03C09696,
		0xED0, 0x03C09696,
		0xED4, 0x03C09696,
		0xED8, 0x03C09696,
		0xEDC, 0x0000D6D6,
		0xEE0, 0x0000D6D6,
		0xEEC, 0x0FC01616,
		0xEE4, 0xB0000C1C,
		0xEE8, 0x00000001,
		0xF14, 0x00000003,
		0xF4C, 0x00000000,
		0xF00, 0x00000300,

};

void
odm_read_and_config_mp_8192e_phy_reg(
	struct	dm_struct *dm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8192e_phy_reg)/sizeof(u32);
	u32	*array = array_mp_8192e_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> odm_read_and_config_mp_8192e_phy_reg\n");

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT, "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(dm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8192e(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8192e_phy_reg(void)
{
		return 61;
}

/******************************************************************************
*                           phy_reg_pg.TXT
******************************************************************************/

u32 array_mp_8192e_phy_reg_pg[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003200,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003200,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x32323200,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x32323200,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36364040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34343636,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x28283234,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x28283032,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x38383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x26283038,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x24262832,
	0, 1, 0, 0x00000838, 0xffffff00, 0x32323200,
	0, 1, 1, 0x00000838, 0xffffff00, 0x32323200,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000032,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000032,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36364040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34343636,
	0, 1, 0, 0x00000834, 0xffffffff, 0x28283234,
	0, 1, 1, 0x00000834, 0xffffffff, 0x28283032,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x38383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000848, 0xffffffff, 0x26283038,
	0, 1, 1, 0x00000848, 0xffffffff, 0x26283032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000868, 0xffffffff, 0x24262832
};

void
odm_read_and_config_mp_8192e_phy_reg_pg(
	struct dm_struct	*dm
)
{
	u32	i = 0;
	u32	array_len = sizeof(array_mp_8192e_phy_reg_pg)/sizeof(u32);
	u32	*array = array_mp_8192e_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	PlatformZeroMemory(hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> odm_read_and_config_mp_8192e_phy_reg_pg\n");

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i+1];
		u32	v3 = array[i+2];
		u32	v4 = array[i+3];
		u32	v5 = array[i+4];
		u32	v6 = array[i+5];

		odm_config_bb_phy_reg_pg_8192e(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



#endif /* end of HWIMG_SUPPORT*/

