///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef.h"
using namespace std;
using namespace rheolef;

//validation de Galerkin Discontinu en transport pur dans un domaine
//rectangulaire 
Float v_theta(Float r) {
  return r;
}
Float uex_r(Float r) {
  return exp(r);
}
Float uex (const point & x) { 
  Float r    = sqrt(sqr(x[0]) + sqr(x[1]));
  return uex_r(r);
}
point v_transport (const point& x) {
  point q;
  Float theta = atan2(x[1],x[0]);
  Float r    = sqrt(sqr(x[0]) + sqr(x[1]));
  Float s = v_theta(r);
  q[0] = s*(-sin(theta));
  q[1] = s*cos(theta);
  return q;
}
// usage: prog xxx.geo tol > yyy.branch
int main (int argc, char **argv) {
  geo omega (argv[1]);
  Float err_l2_expected = (argc > 2) ? atof(argv[2]) : 1e-10;
  space Vh (omega, "P2", "vector");
  space Xh (omega, "P1d");
  field vh = interpolate (Vh, v_transport);
  field uh(Xh);
  form a0 (Xh, Xh, "d_dx0", vh[0]);
  form a1 (Xh, Xh, "d_dx1", vh[1]);
  form m  (Xh, Xh, "mass");
  form cv (Xh, Xh, "convect", vh);
  form invmass(Xh,Xh,"inv_mass");
  form a = (a0 + a1 - cv);
  ssk<Float> a_fact = lu(a.uu);
  form bdr (Xh, Xh, "convect_bdr", vh);
  field one(Xh,1);
  field bdr_cnd = -trans(bdr)*interpolate(Xh,uex);
  uh.u = a_fact.solve(-bdr_cnd.u);
  field e = uh - interpolate (Xh, uex);
  Float error_l2 = sqrt(m(e,e)/m(one,one));
  cerr << "error_l2 = " << error_l2 << endl;
  return (error_l2 < err_l2_expected) ? 0 : 1;
}
