// Copyright 2018 Evgeniy Reizner
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// This file is autogenerated. Do not edit it!

use std::fmt;

/// List of all SVG attributes.
#[derive(Copy,Clone,Eq,PartialEq,Ord,PartialOrd,Hash)]
#[allow(missing_docs)]
pub enum AttributeId {
    AccentHeight,
    Accumulate,
    Actuate,
    Additive,
    AlignmentBaseline,
    Alphabetic,
    Amplitude,
    ArabicForm,
    Arcrole,
    Ascent,
    AttributeName,
    AttributeType,
    Azimuth,
    Base,
    BaseFrequency,
    BaselineShift,
    BaseProfile,
    Bbox,
    Begin,
    Bias,
    By,
    CalcMode,
    CapHeight,
    Class,
    Clip,
    ClipPath,
    ClipRule,
    ClipPathUnits,
    Color,
    ColorInterpolation,
    ColorInterpolationFilters,
    ColorProfile,
    ColorRendering,
    ContentScriptType,
    ContentStyleType,
    Cursor,
    Cx,
    Cy,
    D,
    Descent,
    DiffuseConstant,
    Direction,
    Display,
    Divisor,
    DominantBaseline,
    Dur,
    Dx,
    Dy,
    EdgeMode,
    Elevation,
    EnableBackground,
    Encoding,
    End,
    Exponent,
    ExternalResourcesRequired,
    Fill,
    FillOpacity,
    FillRule,
    Filter,
    FilterRes,
    FilterUnits,
    FloodColor,
    FloodOpacity,
    Font,
    FontFamily,
    FontSize,
    FontSizeAdjust,
    FontStretch,
    FontStyle,
    FontVariant,
    FontWeight,
    Format,
    From,
    Fx,
    Fy,
    G1,
    G2,
    GlyphName,
    GlyphOrientationHorizontal,
    GlyphOrientationVertical,
    GlyphRef,
    GradientTransform,
    GradientUnits,
    Hanging,
    Height,
    HorizAdvX,
    HorizOriginX,
    HorizOriginY,
    Href,
    Id,
    Ideographic,
    ImageRendering,
    In,
    In2,
    Intercept,
    K,
    K1,
    K2,
    K3,
    K4,
    KernelMatrix,
    KernelUnitLength,
    Kerning,
    KeyPoints,
    KeySplines,
    KeyTimes,
    Lang,
    LengthAdjust,
    LetterSpacing,
    LightingColor,
    LimitingConeAngle,
    LineHeight,
    Local,
    Marker,
    MarkerEnd,
    MarkerMid,
    MarkerStart,
    MarkerHeight,
    MarkerUnits,
    MarkerWidth,
    Mask,
    MaskContentUnits,
    MaskUnits,
    Mathematical,
    Max,
    Media,
    Method,
    Min,
    Mode,
    Name,
    NumOctaves,
    Offset,
    Onabort,
    Onactivate,
    Onbegin,
    Onclick,
    Onend,
    Onerror,
    Onfocusin,
    Onfocusout,
    Onload,
    Onmousedown,
    Onmousemove,
    Onmouseout,
    Onmouseover,
    Onmouseup,
    Onrepeat,
    Onresize,
    Onscroll,
    Onunload,
    Onzoom,
    Opacity,
    Operator,
    Order,
    Orient,
    Orientation,
    Origin,
    Overflow,
    OverlinePosition,
    OverlineThickness,
    Panose1,
    Path,
    PathLength,
    PatternContentUnits,
    PatternTransform,
    PatternUnits,
    PointerEvents,
    Points,
    PointsAtX,
    PointsAtY,
    PointsAtZ,
    PreserveAlpha,
    PreserveAspectRatio,
    PrimitiveUnits,
    R,
    Radius,
    RefX,
    RefY,
    RenderingIntent,
    RepeatCount,
    RepeatDur,
    RequiredExtensions,
    RequiredFeatures,
    Restart,
    Result,
    Role,
    Rotate,
    Rx,
    Ry,
    Scale,
    Seed,
    ShapeRendering,
    Show,
    Slope,
    Space,
    Spacing,
    SpecularConstant,
    SpecularExponent,
    SpreadMethod,
    Standalone,
    StartOffset,
    StdDeviation,
    Stemh,
    Stemv,
    StitchTiles,
    StopColor,
    StopOpacity,
    StrikethroughPosition,
    StrikethroughThickness,
    String,
    Stroke,
    StrokeDasharray,
    StrokeDashoffset,
    StrokeLinecap,
    StrokeLinejoin,
    StrokeMiterlimit,
    StrokeOpacity,
    StrokeWidth,
    Style,
    SurfaceScale,
    SystemLanguage,
    TableValues,
    Target,
    TargetX,
    TargetY,
    TextAnchor,
    TextDecoration,
    TextRendering,
    TextLength,
    Title,
    To,
    Transform,
    Type,
    U1,
    U2,
    UnderlinePosition,
    UnderlineThickness,
    Unicode,
    UnicodeBidi,
    UnicodeRange,
    UnitsPerEm,
    VAlphabetic,
    VHanging,
    VIdeographic,
    VMathematical,
    Values,
    Version,
    VertAdvY,
    VertOriginX,
    VertOriginY,
    ViewBox,
    ViewTarget,
    Visibility,
    Width,
    Widths,
    WordSpacing,
    WritingMode,
    X,
    XHeight,
    X1,
    X2,
    XChannelSelector,
    Xlink,
    Xmlns,
    Y,
    Y1,
    Y2,
    YChannelSelector,
    Z,
    ZoomAndPan
}

static ATTRIBUTES: ::phf::Map<&'static str, AttributeId> = ::phf::Map {
    key: 8958141709656110593,
    disps: ::phf::Slice::Static(&[
        (0, 11),
        (0, 0),
        (0, 138),
        (2, 50),
        (1, 8),
        (2, 102),
        (2, 195),
        (0, 1),
        (0, 59),
        (0, 235),
        (0, 0),
        (4, 15),
        (4, 189),
        (0, 13),
        (1, 245),
        (2, 63),
        (0, 68),
        (0, 2),
        (0, 12),
        (0, 200),
        (2, 139),
        (0, 16),
        (0, 198),
        (0, 258),
        (0, 0),
        (0, 190),
        (0, 142),
        (0, 49),
        (1, 261),
        (12, 12),
        (0, 184),
        (0, 251),
        (0, 260),
        (0, 2),
        (1, 0),
        (0, 28),
        (1, 123),
        (0, 232),
        (30, 205),
        (0, 55),
        (0, 13),
        (6, 91),
        (0, 4),
        (11, 76),
        (0, 90),
        (0, 196),
        (0, 19),
        (3, 203),
        (16, 168),
        (0, 0),
        (0, 163),
        (43, 19),
        (0, 7),
        (46, 147),
    ]),
    entries: ::phf::Slice::Static(&[
        ("height", AttributeId::Height),
        ("stroke-linecap", AttributeId::StrokeLinecap),
        ("onmouseup", AttributeId::Onmouseup),
        ("attributeType", AttributeId::AttributeType),
        ("word-spacing", AttributeId::WordSpacing),
        ("onfocusin", AttributeId::Onfocusin),
        ("fill-rule", AttributeId::FillRule),
        ("fy", AttributeId::Fy),
        ("stroke-miterlimit", AttributeId::StrokeMiterlimit),
        ("mathematical", AttributeId::Mathematical),
        ("space", AttributeId::Space),
        ("pathLength", AttributeId::PathLength),
        ("markerWidth", AttributeId::MarkerWidth),
        ("kernelUnitLength", AttributeId::KernelUnitLength),
        ("pointsAtY", AttributeId::PointsAtY),
        ("onzoom", AttributeId::Onzoom),
        ("v-hanging", AttributeId::VHanging),
        ("kernelMatrix", AttributeId::KernelMatrix),
        ("onerror", AttributeId::Onerror),
        ("spacing", AttributeId::Spacing),
        ("onscroll", AttributeId::Onscroll),
        ("onmousemove", AttributeId::Onmousemove),
        ("class", AttributeId::Class),
        ("color-profile", AttributeId::ColorProfile),
        ("accent-height", AttributeId::AccentHeight),
        ("xlink", AttributeId::Xlink),
        ("exponent", AttributeId::Exponent),
        ("cap-height", AttributeId::CapHeight),
        ("d", AttributeId::D),
        ("max", AttributeId::Max),
        ("kerning", AttributeId::Kerning),
        ("slope", AttributeId::Slope),
        ("values", AttributeId::Values),
        ("additive", AttributeId::Additive),
        ("fx", AttributeId::Fx),
        ("preserveAspectRatio", AttributeId::PreserveAspectRatio),
        ("method", AttributeId::Method),
        ("end", AttributeId::End),
        ("onunload", AttributeId::Onunload),
        ("xChannelSelector", AttributeId::XChannelSelector),
        ("u2", AttributeId::U2),
        ("xmlns", AttributeId::Xmlns),
        ("units-per-em", AttributeId::UnitsPerEm),
        ("fill-opacity", AttributeId::FillOpacity),
        ("horiz-adv-x", AttributeId::HorizAdvX),
        ("href", AttributeId::Href),
        ("color-interpolation-filters", AttributeId::ColorInterpolationFilters),
        ("bias", AttributeId::Bias),
        ("specularConstant", AttributeId::SpecularConstant),
        ("seed", AttributeId::Seed),
        ("panose-1", AttributeId::Panose1),
        ("stroke-width", AttributeId::StrokeWidth),
        ("x-height", AttributeId::XHeight),
        ("mode", AttributeId::Mode),
        ("width", AttributeId::Width),
        ("specularExponent", AttributeId::SpecularExponent),
        ("lighting-color", AttributeId::LightingColor),
        ("points", AttributeId::Points),
        ("encoding", AttributeId::Encoding),
        ("image-rendering", AttributeId::ImageRendering),
        ("cx", AttributeId::Cx),
        ("stroke-dashoffset", AttributeId::StrokeDashoffset),
        ("lengthAdjust", AttributeId::LengthAdjust),
        ("writing-mode", AttributeId::WritingMode),
        ("in2", AttributeId::In2),
        ("font-weight", AttributeId::FontWeight),
        ("baseProfile", AttributeId::BaseProfile),
        ("transform", AttributeId::Transform),
        ("overline-thickness", AttributeId::OverlineThickness),
        ("onend", AttributeId::Onend),
        ("origin", AttributeId::Origin),
        ("marker-start", AttributeId::MarkerStart),
        ("alignment-baseline", AttributeId::AlignmentBaseline),
        ("markerUnits", AttributeId::MarkerUnits),
        ("hanging", AttributeId::Hanging),
        ("line-height", AttributeId::LineHeight),
        ("glyph-orientation-horizontal", AttributeId::GlyphOrientationHorizontal),
        ("marker-end", AttributeId::MarkerEnd),
        ("gradientTransform", AttributeId::GradientTransform),
        ("u1", AttributeId::U1),
        ("k2", AttributeId::K2),
        ("text-decoration", AttributeId::TextDecoration),
        ("yChannelSelector", AttributeId::YChannelSelector),
        ("marker", AttributeId::Marker),
        ("gradientUnits", AttributeId::GradientUnits),
        ("mask", AttributeId::Mask),
        ("r", AttributeId::R),
        ("primitiveUnits", AttributeId::PrimitiveUnits),
        ("font-style", AttributeId::FontStyle),
        ("zoomAndPan", AttributeId::ZoomAndPan),
        ("g1", AttributeId::G1),
        ("calcMode", AttributeId::CalcMode),
        ("color", AttributeId::Color),
        ("onmouseover", AttributeId::Onmouseover),
        ("direction", AttributeId::Direction),
        ("contentScriptType", AttributeId::ContentScriptType),
        ("onresize", AttributeId::Onresize),
        ("keyTimes", AttributeId::KeyTimes),
        ("visibility", AttributeId::Visibility),
        ("name", AttributeId::Name),
        ("rx", AttributeId::Rx),
        ("rotate", AttributeId::Rotate),
        ("font", AttributeId::Font),
        ("letter-spacing", AttributeId::LetterSpacing),
        ("enable-background", AttributeId::EnableBackground),
        ("in", AttributeId::In),
        ("v-alphabetic", AttributeId::VAlphabetic),
        ("onmouseout", AttributeId::Onmouseout),
        ("rendering-intent", AttributeId::RenderingIntent),
        ("onactivate", AttributeId::Onactivate),
        ("ideographic", AttributeId::Ideographic),
        ("scale", AttributeId::Scale),
        ("k4", AttributeId::K4),
        ("stdDeviation", AttributeId::StdDeviation),
        ("unicode-bidi", AttributeId::UnicodeBidi),
        ("maskContentUnits", AttributeId::MaskContentUnits),
        ("strikethrough-thickness", AttributeId::StrikethroughThickness),
        ("edgeMode", AttributeId::EdgeMode),
        ("color-interpolation", AttributeId::ColorInterpolation),
        ("pointsAtX", AttributeId::PointsAtX),
        ("surfaceScale", AttributeId::SurfaceScale),
        ("offset", AttributeId::Offset),
        ("stemv", AttributeId::Stemv),
        ("onload", AttributeId::Onload),
        ("pointsAtZ", AttributeId::PointsAtZ),
        ("string", AttributeId::String),
        ("ascent", AttributeId::Ascent),
        ("show", AttributeId::Show),
        ("y1", AttributeId::Y1),
        ("vert-adv-y", AttributeId::VertAdvY),
        ("marker-mid", AttributeId::MarkerMid),
        ("flood-color", AttributeId::FloodColor),
        ("tableValues", AttributeId::TableValues),
        ("vert-origin-x", AttributeId::VertOriginX),
        ("y", AttributeId::Y),
        ("order", AttributeId::Order),
        ("descent", AttributeId::Descent),
        ("patternTransform", AttributeId::PatternTransform),
        ("arcrole", AttributeId::Arcrole),
        ("targetY", AttributeId::TargetY),
        ("base", AttributeId::Base),
        ("maskUnits", AttributeId::MaskUnits),
        ("keyPoints", AttributeId::KeyPoints),
        ("v-mathematical", AttributeId::VMathematical),
        ("target", AttributeId::Target),
        ("textLength", AttributeId::TextLength),
        ("lang", AttributeId::Lang),
        ("baseFrequency", AttributeId::BaseFrequency),
        ("numOctaves", AttributeId::NumOctaves),
        ("dur", AttributeId::Dur),
        ("onabort", AttributeId::Onabort),
        ("opacity", AttributeId::Opacity),
        ("repeatDur", AttributeId::RepeatDur),
        ("text-anchor", AttributeId::TextAnchor),
        ("startOffset", AttributeId::StartOffset),
        ("operator", AttributeId::Operator),
        ("repeatCount", AttributeId::RepeatCount),
        ("format", AttributeId::Format),
        ("font-stretch", AttributeId::FontStretch),
        ("dx", AttributeId::Dx),
        ("pointer-events", AttributeId::PointerEvents),
        ("font-variant", AttributeId::FontVariant),
        ("horiz-origin-x", AttributeId::HorizOriginX),
        ("filterUnits", AttributeId::FilterUnits),
        ("attributeName", AttributeId::AttributeName),
        ("diffuseConstant", AttributeId::DiffuseConstant),
        ("externalResourcesRequired", AttributeId::ExternalResourcesRequired),
        ("v-ideographic", AttributeId::VIdeographic),
        ("viewBox", AttributeId::ViewBox),
        ("role", AttributeId::Role),
        ("filter", AttributeId::Filter),
        ("refX", AttributeId::RefX),
        ("color-rendering", AttributeId::ColorRendering),
        ("stroke-dasharray", AttributeId::StrokeDasharray),
        ("spreadMethod", AttributeId::SpreadMethod),
        ("clip-path", AttributeId::ClipPath),
        ("clip-rule", AttributeId::ClipRule),
        ("text-rendering", AttributeId::TextRendering),
        ("z", AttributeId::Z),
        ("orientation", AttributeId::Orientation),
        ("style", AttributeId::Style),
        ("underline-thickness", AttributeId::UnderlineThickness),
        ("widths", AttributeId::Widths),
        ("cursor", AttributeId::Cursor),
        ("font-family", AttributeId::FontFamily),
        ("dy", AttributeId::Dy),
        ("ry", AttributeId::Ry),
        ("type", AttributeId::Type),
        ("shape-rendering", AttributeId::ShapeRendering),
        ("preserveAlpha", AttributeId::PreserveAlpha),
        ("stop-opacity", AttributeId::StopOpacity),
        ("g2", AttributeId::G2),
        ("k1", AttributeId::K1),
        ("result", AttributeId::Result),
        ("id", AttributeId::Id),
        ("unicode", AttributeId::Unicode),
        ("radius", AttributeId::Radius),
        ("markerHeight", AttributeId::MarkerHeight),
        ("overflow", AttributeId::Overflow),
        ("x1", AttributeId::X1),
        ("glyph-name", AttributeId::GlyphName),
        ("onclick", AttributeId::Onclick),
        ("refY", AttributeId::RefY),
        ("horiz-origin-y", AttributeId::HorizOriginY),
        ("arabic-form", AttributeId::ArabicForm),
        ("font-size", AttributeId::FontSize),
        ("keySplines", AttributeId::KeySplines),
        ("stemh", AttributeId::Stemh),
        ("to", AttributeId::To),
        ("title", AttributeId::Title),
        ("limitingConeAngle", AttributeId::LimitingConeAngle),
        ("begin", AttributeId::Begin),
        ("accumulate", AttributeId::Accumulate),
        ("elevation", AttributeId::Elevation),
        ("azimuth", AttributeId::Azimuth),
        ("font-size-adjust", AttributeId::FontSizeAdjust),
        ("standalone", AttributeId::Standalone),
        ("unicode-range", AttributeId::UnicodeRange),
        ("stitchTiles", AttributeId::StitchTiles),
        ("contentStyleType", AttributeId::ContentStyleType),
        ("cy", AttributeId::Cy),
        ("viewTarget", AttributeId::ViewTarget),
        ("actuate", AttributeId::Actuate),
        ("patternContentUnits", AttributeId::PatternContentUnits),
        ("x2", AttributeId::X2),
        ("fill", AttributeId::Fill),
        ("clipPathUnits", AttributeId::ClipPathUnits),
        ("display", AttributeId::Display),
        ("systemLanguage", AttributeId::SystemLanguage),
        ("clip", AttributeId::Clip),
        ("onmousedown", AttributeId::Onmousedown),
        ("stop-color", AttributeId::StopColor),
        ("from", AttributeId::From),
        ("strikethrough-position", AttributeId::StrikethroughPosition),
        ("targetX", AttributeId::TargetX),
        ("filterRes", AttributeId::FilterRes),
        ("amplitude", AttributeId::Amplitude),
        ("stroke-linejoin", AttributeId::StrokeLinejoin),
        ("intercept", AttributeId::Intercept),
        ("stroke-opacity", AttributeId::StrokeOpacity),
        ("alphabetic", AttributeId::Alphabetic),
        ("k", AttributeId::K),
        ("k3", AttributeId::K3),
        ("orient", AttributeId::Orient),
        ("requiredFeatures", AttributeId::RequiredFeatures),
        ("min", AttributeId::Min),
        ("version", AttributeId::Version),
        ("restart", AttributeId::Restart),
        ("glyph-orientation-vertical", AttributeId::GlyphOrientationVertical),
        ("onrepeat", AttributeId::Onrepeat),
        ("stroke", AttributeId::Stroke),
        ("y2", AttributeId::Y2),
        ("media", AttributeId::Media),
        ("patternUnits", AttributeId::PatternUnits),
        ("onbegin", AttributeId::Onbegin),
        ("vert-origin-y", AttributeId::VertOriginY),
        ("flood-opacity", AttributeId::FloodOpacity),
        ("bbox", AttributeId::Bbox),
        ("overline-position", AttributeId::OverlinePosition),
        ("path", AttributeId::Path),
        ("by", AttributeId::By),
        ("baseline-shift", AttributeId::BaselineShift),
        ("requiredExtensions", AttributeId::RequiredExtensions),
        ("onfocusout", AttributeId::Onfocusout),
        ("x", AttributeId::X),
        ("underline-position", AttributeId::UnderlinePosition),
        ("glyphRef", AttributeId::GlyphRef),
        ("divisor", AttributeId::Divisor),
        ("dominant-baseline", AttributeId::DominantBaseline),
        ("local", AttributeId::Local),
    ]),
};

impl AttributeId {
    /// Converts name into id.
    pub fn from_str(text: &str) -> Option<AttributeId> {
        ATTRIBUTES.get(text).cloned()
    }

    /// Converts id into name.
    pub fn as_str(&self) -> &str {
        match *self {
            AttributeId::AccentHeight => "accent-height",
            AttributeId::Accumulate => "accumulate",
            AttributeId::Actuate => "actuate",
            AttributeId::Additive => "additive",
            AttributeId::AlignmentBaseline => "alignment-baseline",
            AttributeId::Alphabetic => "alphabetic",
            AttributeId::Amplitude => "amplitude",
            AttributeId::ArabicForm => "arabic-form",
            AttributeId::Arcrole => "arcrole",
            AttributeId::Ascent => "ascent",
            AttributeId::AttributeName => "attributeName",
            AttributeId::AttributeType => "attributeType",
            AttributeId::Azimuth => "azimuth",
            AttributeId::Base => "base",
            AttributeId::BaseFrequency => "baseFrequency",
            AttributeId::BaselineShift => "baseline-shift",
            AttributeId::BaseProfile => "baseProfile",
            AttributeId::Bbox => "bbox",
            AttributeId::Begin => "begin",
            AttributeId::Bias => "bias",
            AttributeId::By => "by",
            AttributeId::CalcMode => "calcMode",
            AttributeId::CapHeight => "cap-height",
            AttributeId::Class => "class",
            AttributeId::Clip => "clip",
            AttributeId::ClipPath => "clip-path",
            AttributeId::ClipRule => "clip-rule",
            AttributeId::ClipPathUnits => "clipPathUnits",
            AttributeId::Color => "color",
            AttributeId::ColorInterpolation => "color-interpolation",
            AttributeId::ColorInterpolationFilters => "color-interpolation-filters",
            AttributeId::ColorProfile => "color-profile",
            AttributeId::ColorRendering => "color-rendering",
            AttributeId::ContentScriptType => "contentScriptType",
            AttributeId::ContentStyleType => "contentStyleType",
            AttributeId::Cursor => "cursor",
            AttributeId::Cx => "cx",
            AttributeId::Cy => "cy",
            AttributeId::D => "d",
            AttributeId::Descent => "descent",
            AttributeId::DiffuseConstant => "diffuseConstant",
            AttributeId::Direction => "direction",
            AttributeId::Display => "display",
            AttributeId::Divisor => "divisor",
            AttributeId::DominantBaseline => "dominant-baseline",
            AttributeId::Dur => "dur",
            AttributeId::Dx => "dx",
            AttributeId::Dy => "dy",
            AttributeId::EdgeMode => "edgeMode",
            AttributeId::Elevation => "elevation",
            AttributeId::EnableBackground => "enable-background",
            AttributeId::Encoding => "encoding",
            AttributeId::End => "end",
            AttributeId::Exponent => "exponent",
            AttributeId::ExternalResourcesRequired => "externalResourcesRequired",
            AttributeId::Fill => "fill",
            AttributeId::FillOpacity => "fill-opacity",
            AttributeId::FillRule => "fill-rule",
            AttributeId::Filter => "filter",
            AttributeId::FilterRes => "filterRes",
            AttributeId::FilterUnits => "filterUnits",
            AttributeId::FloodColor => "flood-color",
            AttributeId::FloodOpacity => "flood-opacity",
            AttributeId::Font => "font",
            AttributeId::FontFamily => "font-family",
            AttributeId::FontSize => "font-size",
            AttributeId::FontSizeAdjust => "font-size-adjust",
            AttributeId::FontStretch => "font-stretch",
            AttributeId::FontStyle => "font-style",
            AttributeId::FontVariant => "font-variant",
            AttributeId::FontWeight => "font-weight",
            AttributeId::Format => "format",
            AttributeId::From => "from",
            AttributeId::Fx => "fx",
            AttributeId::Fy => "fy",
            AttributeId::G1 => "g1",
            AttributeId::G2 => "g2",
            AttributeId::GlyphName => "glyph-name",
            AttributeId::GlyphOrientationHorizontal => "glyph-orientation-horizontal",
            AttributeId::GlyphOrientationVertical => "glyph-orientation-vertical",
            AttributeId::GlyphRef => "glyphRef",
            AttributeId::GradientTransform => "gradientTransform",
            AttributeId::GradientUnits => "gradientUnits",
            AttributeId::Hanging => "hanging",
            AttributeId::Height => "height",
            AttributeId::HorizAdvX => "horiz-adv-x",
            AttributeId::HorizOriginX => "horiz-origin-x",
            AttributeId::HorizOriginY => "horiz-origin-y",
            AttributeId::Href => "href",
            AttributeId::Id => "id",
            AttributeId::Ideographic => "ideographic",
            AttributeId::ImageRendering => "image-rendering",
            AttributeId::In => "in",
            AttributeId::In2 => "in2",
            AttributeId::Intercept => "intercept",
            AttributeId::K => "k",
            AttributeId::K1 => "k1",
            AttributeId::K2 => "k2",
            AttributeId::K3 => "k3",
            AttributeId::K4 => "k4",
            AttributeId::KernelMatrix => "kernelMatrix",
            AttributeId::KernelUnitLength => "kernelUnitLength",
            AttributeId::Kerning => "kerning",
            AttributeId::KeyPoints => "keyPoints",
            AttributeId::KeySplines => "keySplines",
            AttributeId::KeyTimes => "keyTimes",
            AttributeId::Lang => "lang",
            AttributeId::LengthAdjust => "lengthAdjust",
            AttributeId::LetterSpacing => "letter-spacing",
            AttributeId::LightingColor => "lighting-color",
            AttributeId::LimitingConeAngle => "limitingConeAngle",
            AttributeId::LineHeight => "line-height",
            AttributeId::Local => "local",
            AttributeId::Marker => "marker",
            AttributeId::MarkerEnd => "marker-end",
            AttributeId::MarkerMid => "marker-mid",
            AttributeId::MarkerStart => "marker-start",
            AttributeId::MarkerHeight => "markerHeight",
            AttributeId::MarkerUnits => "markerUnits",
            AttributeId::MarkerWidth => "markerWidth",
            AttributeId::Mask => "mask",
            AttributeId::MaskContentUnits => "maskContentUnits",
            AttributeId::MaskUnits => "maskUnits",
            AttributeId::Mathematical => "mathematical",
            AttributeId::Max => "max",
            AttributeId::Media => "media",
            AttributeId::Method => "method",
            AttributeId::Min => "min",
            AttributeId::Mode => "mode",
            AttributeId::Name => "name",
            AttributeId::NumOctaves => "numOctaves",
            AttributeId::Offset => "offset",
            AttributeId::Onabort => "onabort",
            AttributeId::Onactivate => "onactivate",
            AttributeId::Onbegin => "onbegin",
            AttributeId::Onclick => "onclick",
            AttributeId::Onend => "onend",
            AttributeId::Onerror => "onerror",
            AttributeId::Onfocusin => "onfocusin",
            AttributeId::Onfocusout => "onfocusout",
            AttributeId::Onload => "onload",
            AttributeId::Onmousedown => "onmousedown",
            AttributeId::Onmousemove => "onmousemove",
            AttributeId::Onmouseout => "onmouseout",
            AttributeId::Onmouseover => "onmouseover",
            AttributeId::Onmouseup => "onmouseup",
            AttributeId::Onrepeat => "onrepeat",
            AttributeId::Onresize => "onresize",
            AttributeId::Onscroll => "onscroll",
            AttributeId::Onunload => "onunload",
            AttributeId::Onzoom => "onzoom",
            AttributeId::Opacity => "opacity",
            AttributeId::Operator => "operator",
            AttributeId::Order => "order",
            AttributeId::Orient => "orient",
            AttributeId::Orientation => "orientation",
            AttributeId::Origin => "origin",
            AttributeId::Overflow => "overflow",
            AttributeId::OverlinePosition => "overline-position",
            AttributeId::OverlineThickness => "overline-thickness",
            AttributeId::Panose1 => "panose-1",
            AttributeId::Path => "path",
            AttributeId::PathLength => "pathLength",
            AttributeId::PatternContentUnits => "patternContentUnits",
            AttributeId::PatternTransform => "patternTransform",
            AttributeId::PatternUnits => "patternUnits",
            AttributeId::PointerEvents => "pointer-events",
            AttributeId::Points => "points",
            AttributeId::PointsAtX => "pointsAtX",
            AttributeId::PointsAtY => "pointsAtY",
            AttributeId::PointsAtZ => "pointsAtZ",
            AttributeId::PreserveAlpha => "preserveAlpha",
            AttributeId::PreserveAspectRatio => "preserveAspectRatio",
            AttributeId::PrimitiveUnits => "primitiveUnits",
            AttributeId::R => "r",
            AttributeId::Radius => "radius",
            AttributeId::RefX => "refX",
            AttributeId::RefY => "refY",
            AttributeId::RenderingIntent => "rendering-intent",
            AttributeId::RepeatCount => "repeatCount",
            AttributeId::RepeatDur => "repeatDur",
            AttributeId::RequiredExtensions => "requiredExtensions",
            AttributeId::RequiredFeatures => "requiredFeatures",
            AttributeId::Restart => "restart",
            AttributeId::Result => "result",
            AttributeId::Role => "role",
            AttributeId::Rotate => "rotate",
            AttributeId::Rx => "rx",
            AttributeId::Ry => "ry",
            AttributeId::Scale => "scale",
            AttributeId::Seed => "seed",
            AttributeId::ShapeRendering => "shape-rendering",
            AttributeId::Show => "show",
            AttributeId::Slope => "slope",
            AttributeId::Space => "space",
            AttributeId::Spacing => "spacing",
            AttributeId::SpecularConstant => "specularConstant",
            AttributeId::SpecularExponent => "specularExponent",
            AttributeId::SpreadMethod => "spreadMethod",
            AttributeId::Standalone => "standalone",
            AttributeId::StartOffset => "startOffset",
            AttributeId::StdDeviation => "stdDeviation",
            AttributeId::Stemh => "stemh",
            AttributeId::Stemv => "stemv",
            AttributeId::StitchTiles => "stitchTiles",
            AttributeId::StopColor => "stop-color",
            AttributeId::StopOpacity => "stop-opacity",
            AttributeId::StrikethroughPosition => "strikethrough-position",
            AttributeId::StrikethroughThickness => "strikethrough-thickness",
            AttributeId::String => "string",
            AttributeId::Stroke => "stroke",
            AttributeId::StrokeDasharray => "stroke-dasharray",
            AttributeId::StrokeDashoffset => "stroke-dashoffset",
            AttributeId::StrokeLinecap => "stroke-linecap",
            AttributeId::StrokeLinejoin => "stroke-linejoin",
            AttributeId::StrokeMiterlimit => "stroke-miterlimit",
            AttributeId::StrokeOpacity => "stroke-opacity",
            AttributeId::StrokeWidth => "stroke-width",
            AttributeId::Style => "style",
            AttributeId::SurfaceScale => "surfaceScale",
            AttributeId::SystemLanguage => "systemLanguage",
            AttributeId::TableValues => "tableValues",
            AttributeId::Target => "target",
            AttributeId::TargetX => "targetX",
            AttributeId::TargetY => "targetY",
            AttributeId::TextAnchor => "text-anchor",
            AttributeId::TextDecoration => "text-decoration",
            AttributeId::TextRendering => "text-rendering",
            AttributeId::TextLength => "textLength",
            AttributeId::Title => "title",
            AttributeId::To => "to",
            AttributeId::Transform => "transform",
            AttributeId::Type => "type",
            AttributeId::U1 => "u1",
            AttributeId::U2 => "u2",
            AttributeId::UnderlinePosition => "underline-position",
            AttributeId::UnderlineThickness => "underline-thickness",
            AttributeId::Unicode => "unicode",
            AttributeId::UnicodeBidi => "unicode-bidi",
            AttributeId::UnicodeRange => "unicode-range",
            AttributeId::UnitsPerEm => "units-per-em",
            AttributeId::VAlphabetic => "v-alphabetic",
            AttributeId::VHanging => "v-hanging",
            AttributeId::VIdeographic => "v-ideographic",
            AttributeId::VMathematical => "v-mathematical",
            AttributeId::Values => "values",
            AttributeId::Version => "version",
            AttributeId::VertAdvY => "vert-adv-y",
            AttributeId::VertOriginX => "vert-origin-x",
            AttributeId::VertOriginY => "vert-origin-y",
            AttributeId::ViewBox => "viewBox",
            AttributeId::ViewTarget => "viewTarget",
            AttributeId::Visibility => "visibility",
            AttributeId::Width => "width",
            AttributeId::Widths => "widths",
            AttributeId::WordSpacing => "word-spacing",
            AttributeId::WritingMode => "writing-mode",
            AttributeId::X => "x",
            AttributeId::XHeight => "x-height",
            AttributeId::X1 => "x1",
            AttributeId::X2 => "x2",
            AttributeId::XChannelSelector => "xChannelSelector",
            AttributeId::Xlink => "xlink",
            AttributeId::Xmlns => "xmlns",
            AttributeId::Y => "y",
            AttributeId::Y1 => "y1",
            AttributeId::Y2 => "y2",
            AttributeId::YChannelSelector => "yChannelSelector",
            AttributeId::Z => "z",
            AttributeId::ZoomAndPan => "zoomAndPan"
        }
    }
}

impl fmt::Debug for AttributeId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.as_str())
    }
}

impl fmt::Display for AttributeId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.as_str())
    }
}
