9.4 Ticking

# Avance automatique ("ticking")

Il est probable que vous vous trouverez quelquefois en train d'en faire 
des tas quand votre codage en "live" consistera à boucler au travers 
d'anneaux. Vous mettrez des notes dans des anneaux ("rings") pour les 
mélodies, des "sleeps" pour les rythmes, des progressions d'accords, des 
variations de timbre, etc. etc.

## Parcours automatique des anneaux

Sonic Pi fournit un outil *très* pratique pour travailler avec des anneaux 
("rings") à l'intérieur des `live_loop`s. Il s'agit du système d'avance 
automatique ("tick"). Dans la section sur les anneaux on parlait d'un
compteur qui augmente constamment, comme un nombre courant de
battement. "Tick" implémente justement cette idée.  Il vous fournit
la capacité de *parcourir des anneaux*.
Regardons un exemple :

```
counter = 0
live_loop :arp do
  play (scale :e3, :minor_pentatonic)[counter], release: 0.1
  counter += 1
  sleep 0.125
end
```

C'est l'équivalent de :

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end
```

Ici, nous prenons simplement la gamme mineure pentatonique de Mi3 et 
nous la parcourons élement par élément. C'est réalisé en ajoutant `.tick` 
à la fin de la déclaration de la gamme. Ce "tick" est local à la 
boucle live, ainsi chaque boucle live a son propre "tick" indépendant :

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end

live_loop :arp2 do
  use_synth :dsaw
  play (scale :e2, :minor_pentatonic, num_octaves: 3).tick, release: 0.25
  sleep 0.25
end
```

## Fonction Tick

Vous pouvez également appeler `tick` comme une fonction standard et 
utiliser sa valeur de retour comme un index : 

```
live_loop :arp do
  idx = tick
  play (scale :e3, :minor_pentatonic)[idx], release: 0.1
  sleep 0.125
end
```

Cependant, c'est plus joli d'appeler `.tick` à la fin. La fonction `.tick` 
est faite pour les cas où vous voulez faire des fantaisies avec la valeur 
retournée ou utiliser les "ticks" pour autre chose que l'indexation des 
anneaux.


## Fonction Look

La chose magique apportée par "tick" est que non seulement un nouvel 
index est retourné (ou la valeur de l'anneau à cet index) mais qu'il 
garantit que la fois suivante où vous l'appellerez, vous obtiendrez la 
valeur suivante. Jetez un œil sur les exemples de la documentation de
`.tick` pour voir les différentes façons de l'employer. Toutefois, 
pour le moment, il est important de souligner que quelquefois, vous 
voulez juste obtenir la valeur courante de "tick" sans l'*incrémenter*. 
Ceci est disponible via la fonction `look`. Vous pouvez appeler `look` 
comme une fonction standard ou ajouter `.look` à la fin d'un anneau.

## Nommage des Ticks
 
Finalement, vous avez quelquefois besoin de plus d'un "tick" par boucle 
live. C'est réalisé en donnant un nom à vos "ticks" :

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick(:foo), release: 0.1
  sleep (ring 0.125, 0.25).tick(:bar)
end
```

Ici, nous utilisons deux "ticks", un pour la note à jouer et un autre 
pour la durée de "sleep". Comme ils sont tous deux dans la même 
boucle, pour les maintenir indépendants, nous devons leur donner des 
noms uniques. C'est exactement le même genre de solution que dans le cas  
du nommage des `live_loop`s - nous passons simplement un symbole précédé 
d'un `:`. Dans l'exemple ci-dessus, nous avons appelé un "tick" `:foo` 
et l'autre `:bar`. Si nous voulons juste connaître leur valeur, nous 
devons aussi passer le nom du "tick" à `look`.

## Ne faites pas de choses trop compliquées

La plupart de la puissance du système des "ticks" n'est pas utile quand 
vous débutez. N'essayez pas et n'apprenez pas tout de cette section. 
Concentrez-vous seulement sur le parcours d'un simple anneau. Cela vous 
procurera la plus grande part de la joie et de la simplicité du 
parcours des anneaux dans vos `live_loop`s.

Jetez un œil sur la documentation des `tick`s où se trouvent de nombreux 
exemples utiles, et joyeux parcours automatiques !

