/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHPARAM_H
#define _SC_LOGGRAPHPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/LogEntryTypes.h"


/**
 * Parameter class for LogGraphCmd.
 */

class LogGraphBaton
{
public:
  virtual void setUrlInfo( const sc::String& root, const sc::String& url ) = 0;
  virtual void addLogMsg( const svn::LogEntryPtr log ) = 0;
};


class LogGraphParam : public ScParam
{
public:
  LogGraphParam( const sc::String& src, LogGraphBaton* baton )
    : _src(src), _baton(baton)
  {
  }

  const sc::String& getSource() const
  {
    return _src;
  }

  LogGraphBaton* getBaton() const
  {
    return _baton;
  }

  ScParamAccept(LogGraphParam);

private:
  // in
  sc::String     _src;
  LogGraphBaton* _baton;
};

#endif // _SC_LOGGRAPHPARAM_H
