/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.net.URI;
import java.util.Stack;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class AddXmlBase
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName xml_base = new QName("http://www.w3.org/XML/1998/namespace", "base");
    private static final QName _all = new QName("", "all");
    private static final QName _relative = new QName("", "relative");
    private ProcessMatch matcher = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private boolean all = false;
    private boolean relative = false;
    private Stack<URI> baseURIStack = new Stack();

    public AddXmlBase(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.all = this.getOption(_all, false);
        this.relative = this.getOption(_relative, true);
        if (this.all && this.relative) {
            throw XProcException.stepError(58);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), new RuntimeValue("*", this.step.getNode()));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        boolean addXmlBase;
        String xmlBase = node.getBaseURI().normalize().toASCIIString();
        boolean bl = addXmlBase = this.all || this.baseURIStack.size() == 0;
        if (!addXmlBase) {
            boolean bl2 = addXmlBase = !this.baseURIStack.peek().equals(node.getBaseURI());
        }
        if (addXmlBase && this.relative && this.baseURIStack.size() > 0) {
            URI relURI = node.getBaseURI();
            String p1 = this.baseURIStack.peek().toASCIIString();
            String p2 = relURI.toASCIIString();
            boolean commonancestor = false;
            int i1 = p1.indexOf("/");
            int i2 = p2.indexOf("/");
            while (i1 >= 0 && i2 >= 0 && p1.substring(0, i1).equals(p2.substring(0, i2))) {
                commonancestor = true;
                p1 = p1.substring(i1 + 1);
                p2 = p2.substring(i2 + 1);
                i1 = p1.indexOf("/");
                i2 = p2.indexOf("/");
            }
            if (commonancestor) {
                String walkUp = "";
                i1 = p1.indexOf("/");
                while (i1 >= 0) {
                    walkUp = walkUp + "../";
                    p1 = p1.substring(i1 + 1);
                    i1 = p1.indexOf("/");
                }
                xmlBase = walkUp + p2;
                p1 = "5";
            } else {
                xmlBase = relURI.toASCIIString();
            }
        }
        this.baseURIStack.push(node.getBaseURI());
        this.matcher.addStartElement(node);
        boolean found = false;
        XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeName().equals((Object)xml_base)) {
                found = true;
                if (!this.all && !addXmlBase && node.getAttributeValue(xml_base).equals(xmlBase) || "".equals(xmlBase)) continue;
                this.matcher.addAttribute(child, xmlBase);
                continue;
            }
            this.matcher.addAttribute(child, child.getStringValue());
        }
        if (!found && addXmlBase) {
            this.matcher.addAttribute(xml_base, xmlBase);
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
        this.baseURIStack.pop();
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("This can't happen");
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("This can't happen");
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("This can't happen");
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("This can't happen");
    }
}

