/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;
    private PhrasePositions[] repeats;
    private PhrasePositions[] tmpPos;
    private boolean checkedRepeats;

    SloppyPhraseScorer(Weight weight, TermPositions[] tps, int[] offsets, Similarity similarity, int slop, byte[] norms) {
        super(weight, tps, offsets, similarity, norms);
        this.slop = slop;
    }

    protected final float phraseFreq() throws IOException {
        boolean done;
        int end = this.initPhrasePositions();
        float freq = 0.0f;
        boolean bl = done = end < 0;
        while (!done) {
            int matchLength;
            PhrasePositions pp = (PhrasePositions)this.pq.pop();
            int start = pp.position;
            int next = ((PhrasePositions)this.pq.top()).position;
            boolean tpsDiffer = true;
            int pos = start;
            while (pos <= next || !tpsDiffer) {
                if (pos <= next && tpsDiffer) {
                    start = pos;
                }
                if (!pp.nextPosition()) {
                    done = true;
                    break;
                }
                PhrasePositions pp2 = null;
                boolean bl2 = tpsDiffer = !pp.repeats || (pp2 = this.termPositionsDiffer(pp)) == null;
                if (pp2 != null && pp2 != pp) {
                    pp = this.flip(pp, pp2);
                }
                pos = pp.position;
            }
            if ((matchLength = end - start) <= this.slop) {
                freq += this.getSimilarity().sloppyFreq(matchLength);
            }
            if (pp.position > end) {
                end = pp.position;
            }
            this.pq.add(pp);
        }
        return freq;
    }

    private PhrasePositions flip(PhrasePositions pp, PhrasePositions pp2) {
        PhrasePositions pp3;
        int n = 0;
        while ((pp3 = (PhrasePositions)this.pq.pop()) != pp2) {
            this.tmpPos[n++] = pp3;
        }
        --n;
        while (n >= 0) {
            this.pq.insertWithOverflow(this.tmpPos[n]);
            --n;
        }
        this.pq.add(pp);
        return pp2;
    }

    private int initPhrasePositions() throws IOException {
        PhrasePositions pp;
        int end = 0;
        if (this.checkedRepeats && this.repeats == null) {
            this.pq.clear();
            PhrasePositions pp2 = this.first;
            while (pp2 != null) {
                pp2.firstPosition();
                if (pp2.position > end) {
                    end = pp2.position;
                }
                this.pq.add(pp2);
                pp2 = pp2.next;
            }
            return end;
        }
        PhrasePositions pp3 = this.first;
        while (pp3 != null) {
            pp3.firstPosition();
            pp3 = pp3.next;
        }
        if (!this.checkedRepeats) {
            this.checkedRepeats = true;
            HashMap<PhrasePositions, Object> m = null;
            pp = this.first;
            while (pp != null) {
                int tpPos = pp.position + pp.offset;
                PhrasePositions pp2 = pp.next;
                while (pp2 != null) {
                    int tpPos2 = pp2.position + pp2.offset;
                    if (tpPos2 == tpPos) {
                        if (m == null) {
                            m = new HashMap<PhrasePositions, Object>();
                        }
                        pp.repeats = true;
                        pp2.repeats = true;
                        m.put(pp, null);
                        m.put(pp2, null);
                    }
                    pp2 = pp2.next;
                }
                pp = pp.next;
            }
            if (m != null) {
                this.repeats = m.keySet().toArray(new PhrasePositions[0]);
            }
        }
        if (this.repeats != null) {
            for (int i = 0; i < this.repeats.length; ++i) {
                PhrasePositions pp2;
                pp = this.repeats[i];
                while ((pp2 = this.termPositionsDiffer(pp)) != null) {
                    if (pp2.nextPosition()) continue;
                    return -1;
                }
            }
        }
        this.pq.clear();
        pp = this.first;
        while (pp != null) {
            if (pp.position > end) {
                end = pp.position;
            }
            this.pq.add(pp);
            pp = pp.next;
        }
        if (this.repeats != null) {
            this.tmpPos = new PhrasePositions[this.pq.size()];
        }
        return end;
    }

    private PhrasePositions termPositionsDiffer(PhrasePositions pp) {
        int tpPos = pp.position + pp.offset;
        for (int i = 0; i < this.repeats.length; ++i) {
            int tpPos2;
            PhrasePositions pp2 = this.repeats[i];
            if (pp2 == pp || (tpPos2 = pp2.position + pp2.offset) != tpPos) continue;
            return pp.offset > pp2.offset ? pp : pp2;
        }
        return null;
    }
}

