/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class PrecisionDecimalValue
extends NumericValue {
    public static final int DIVIDE_PRECISION = 18;
    private static final int ORDINARY_VALUE = 0;
    private static final int NEGATIVE_ZERO_DATAPOINT = 1;
    private static final int NEGATIVE_INFINITY_DATAPOINT = 2;
    private static final int POSITIVE_INFINITY_DATAPOINT = 3;
    private static final int NAN_DATAPOINT = 4;
    private int dataPoint;
    private BigDecimal value;
    public static final PrecisionDecimalValue ZERO = new PrecisionDecimalValue(BigDecimal.ZERO);
    public static final PrecisionDecimalValue ONE = new PrecisionDecimalValue(BigDecimal.ONE);
    public static final PrecisionDecimalValue POSITIVE_INFINITY = new PrecisionDecimalValue(BigDecimal.ZERO, 3);
    public static final PrecisionDecimalValue NEGATIVE_INFINITY = new PrecisionDecimalValue(BigDecimal.ZERO, 2);
    public static final PrecisionDecimalValue NEGATIVE_ZERO = new PrecisionDecimalValue(BigDecimal.ZERO, 1);
    public static final PrecisionDecimalValue NaN = new PrecisionDecimalValue(BigDecimal.ZERO, 4);
    private static final Pattern precisionDecimalPattern = Pattern.compile("[-+]?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee][-+]?[0-9]+)?|[-+]?INF|NaN");

    private PrecisionDecimalValue() {
        this.dataPoint = 0;
        this.value = BigDecimal.ZERO;
        this.typeLabel = BuiltInAtomicType.PRECISION_DECIMAL;
    }

    public PrecisionDecimalValue(BigDecimal value) {
        this.dataPoint = 0;
        this.value = value;
        this.typeLabel = BuiltInAtomicType.PRECISION_DECIMAL;
    }

    private PrecisionDecimalValue(BigDecimal value, int dataPoint) {
        this.dataPoint = dataPoint;
        this.value = value;
        this.typeLabel = BuiltInAtomicType.PRECISION_DECIMAL;
    }

    public PrecisionDecimalValue(double in) {
        if (Double.isNaN(in)) {
            this.value = BigDecimal.ZERO;
            this.dataPoint = 4;
        } else if (Double.isInfinite(in)) {
            this.value = BigDecimal.ZERO;
            this.dataPoint = in > 0.0 ? 3 : 2;
        } else if (in == 0.0 && Double.doubleToRawLongBits(in) == Double.doubleToRawLongBits(-0.0)) {
            this.value = BigDecimal.ZERO;
            this.dataPoint = 1;
        } else {
            this.dataPoint = 0;
            BigDecimal d = new BigDecimal(in);
            this.value = d.stripTrailingZeros();
        }
        this.typeLabel = BuiltInAtomicType.PRECISION_DECIMAL;
    }

    public static ConversionResult makePrecisionDecimalValue(CharSequence in, boolean validate) {
        String s = ((Object)Whitespace.collapseWhitespace(in)).toString();
        if (s.equals("INF")) {
            return POSITIVE_INFINITY;
        }
        if (s.equals("+INF")) {
            return POSITIVE_INFINITY;
        }
        if (s.equals("-INF")) {
            return NEGATIVE_INFINITY;
        }
        if (s.equals("NaN")) {
            return NaN;
        }
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) <= '\u0080') continue;
            return new ValidationFailure("Cannot convert string " + Err.wrap(Whitespace.trim(in), 4) + " to xs:precisionDecimal: contains non-ASCII characters");
        }
        try {
            BigDecimal v = new BigDecimal(s);
            int dataPoint = 0;
            if (v.compareTo(BigDecimal.ZERO) == 0 && s.charAt(0) == '-') {
                dataPoint = 1;
            }
            return new PrecisionDecimalValue(v, dataPoint);
        }
        catch (NumberFormatException err) {
            ValidationFailure e = new ValidationFailure("Cannot convert string " + Err.wrap(Whitespace.trim(in), 4) + " to xs:precisionDecimal: " + err.getMessage());
            e.setErrorCode("FORG0001");
            return e;
        }
    }

    public static boolean castableAsPrecisionDecimal(CharSequence in) {
        CharSequence trimmed = Whitespace.trimWhitespace(in);
        return precisionDecimalPattern.matcher(trimmed).matches();
    }

    public PrecisionDecimalValue(long in) {
        this.value = BigDecimal.valueOf(in);
        this.dataPoint = 0;
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        PrecisionDecimalValue v = new PrecisionDecimalValue();
        v.value = this.value;
        v.dataPoint = this.dataPoint;
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.PRECISION_DECIMAL;
    }

    public BigDecimal getDecimalValue() {
        return this.value;
    }

    public boolean isNaN() {
        return this.dataPoint == 4;
    }

    public boolean isInfinite() {
        return this.dataPoint == 3 || this.dataPoint == 2;
    }

    public int hashCode() {
        BigDecimal round = this.value.setScale(0, 1);
        long value = round.longValue();
        if (value > Integer.MIN_VALUE && value < Integer.MAX_VALUE) {
            return (int)value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean effectiveBooleanValue() {
        return this.value.signum() != 0;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, ConversionRules rules) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.value.signum() != 0);
            }
            case 532: 
            case 632: 
            case 635: {
                return this;
            }
            case 515: {
                if (this.dataPoint == 0 || this.dataPoint == 1) {
                    return new DecimalValue(this.value);
                }
                ValidationFailure err = new ValidationFailure("Cannot convert precision decimal value " + this.toString() + " to " + requiredType.getDisplayName());
                err.setErrorCode("FORG0001");
                return err;
            }
            case 533: {
                if (this.dataPoint == 0 || this.dataPoint == 1) {
                    return BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
                }
                ValidationFailure err = new ValidationFailure("Cannot convert precision decimal value " + this.toString() + " to " + requiredType.getDisplayName());
                err.setErrorCode("FORG0001");
                return err;
            }
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: {
                IntegerValue iv = BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
                return iv.convertPrimitive(requiredType, validate, rules);
            }
            case 517: {
                if (this.dataPoint == 3) {
                    return new DoubleValue(Double.POSITIVE_INFINITY);
                }
                if (this.dataPoint == 2) {
                    return new DoubleValue(Double.NEGATIVE_INFINITY);
                }
                if (this.dataPoint == 4) {
                    return new DoubleValue(Double.NaN);
                }
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                if (this.dataPoint == 3) {
                    return new FloatValue(Float.POSITIVE_INFINITY);
                }
                if (this.dataPoint == 2) {
                    return new FloatValue(Float.NEGATIVE_INFINITY);
                }
                if (this.dataPoint == 4) {
                    return new FloatValue(Float.NaN);
                }
                return new FloatValue(this.value.floatValue());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert precision decimal to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        String s = this.getStringValue();
        if (s.indexOf(46) < 0) {
            s = s + ".0";
        }
        return s;
    }

    public CharSequence getPrimitiveStringValue() {
        switch (this.dataPoint) {
            case 0: {
                return this.value.toString();
            }
            case 1: {
                return "-" + this.value.toString();
            }
            case 3: {
                return "INF";
            }
            case 2: {
                return "-INF";
            }
        }
        return "NaN";
    }

    public boolean checkTotalDigits(int requiredValue) {
        switch (this.dataPoint) {
            case 0: 
            case 1: {
                return this.equals(DecimalValue.ZERO) || this.value.precision() <= requiredValue;
            }
        }
        return true;
    }

    public boolean checkMinScale(int requiredValue) {
        switch (this.dataPoint) {
            case 0: 
            case 1: {
                return this.value.scale() >= requiredValue;
            }
        }
        return true;
    }

    public boolean checkMaxScale(int requiredValue) {
        switch (this.dataPoint) {
            case 0: 
            case 1: {
                return this.value.scale() <= requiredValue;
            }
        }
        return true;
    }

    public NumericValue negate() {
        switch (this.dataPoint) {
            case 0: {
                return new PrecisionDecimalValue(this.value.negate());
            }
            case 1: {
                return ZERO;
            }
            case 3: {
                return NEGATIVE_INFINITY;
            }
            case 2: {
                return POSITIVE_INFINITY;
            }
        }
        return this;
    }

    public NumericValue floor() {
        if (this.dataPoint != 0) {
            return this;
        }
        return new PrecisionDecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue ceiling() {
        if (this.dataPoint != 0) {
            return this;
        }
        return new PrecisionDecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue round(int scale) {
        if (this.dataPoint != 0) {
            return this;
        }
        switch (this.value.signum()) {
            case -1: {
                return new PrecisionDecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new PrecisionDecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        BigDecimal scaledValue = this.value.setScale(scale, 6);
        return new DecimalValue(scaledValue);
    }

    public double signum() {
        switch (this.dataPoint) {
            case 0: {
                return this.value.signum();
            }
            case 1: {
                return 0.0;
            }
            case 3: {
                return 1.0;
            }
            case 2: {
                return -1.0;
            }
        }
        return Double.NaN;
    }

    public boolean isWholeNumber() {
        switch (this.dataPoint) {
            case 0: {
                return this.value.scale() == 0 || this.value.compareTo(this.value.setScale(0, 1)) == 0;
            }
            case 1: {
                return true;
            }
            case 3: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public NumericValue abs() {
        switch (this.dataPoint) {
            case 0: {
                if (this.value.signum() > 0) {
                    return this;
                }
                return this.negate();
            }
            case 1: {
                return ZERO;
            }
            case 3: {
                return this;
            }
            case 2: {
                return POSITIVE_INFINITY;
            }
        }
        return this;
    }

    public int compareTo(Object other) {
        if (NumericValue.isInteger((NumericValue)other)) {
            try {
                return this.compareTo(((NumericValue)other).convertPrimitive(BuiltInAtomicType.DECIMAL, true, null).asAtomic());
            }
            catch (XPathException err) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (other instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)other).getDecimalValue());
        }
        if (other instanceof PrecisionDecimalValue) {
            int sc = this.getSchemaComparable().compareTo(((PrecisionDecimalValue)other).getSchemaComparable());
            if (sc == Integer.MIN_VALUE) {
                return 1;
            }
            return sc;
        }
        if (other instanceof FloatValue) {
            try {
                return ((FloatValue)this.convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic()).compareTo(other);
            }
            catch (XPathException err) {
                throw new AssertionError((Object)"Conversion of decimal to float should never fail");
            }
        }
        return super.compareTo(other);
    }

    public int compareTo(long other) {
        if (other == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigDecimal.valueOf(other));
    }

    public Comparable getSchemaComparable() {
        return new PrecisionDecimalComparable(this);
    }

    public boolean isIdentical(Value v) {
        return v instanceof PrecisionDecimalValue && this.equals(v);
    }

    protected static class PrecisionDecimalComparable
    implements Comparable {
        protected PrecisionDecimalValue pdv;

        public PrecisionDecimalComparable(PrecisionDecimalValue value) {
            this.pdv = value;
        }

        public BigDecimal asBigDecimal() {
            return this.pdv.getDecimalValue();
        }

        public int compareTo(Object o) {
            if (o instanceof PrecisionDecimalComparable) {
                PrecisionDecimalValue pdv2 = ((PrecisionDecimalComparable)o).pdv;
                switch (this.pdv.dataPoint) {
                    case 0: 
                    case 1: {
                        switch (pdv2.dataPoint) {
                            case 0: 
                            case 1: {
                                return this.asBigDecimal().compareTo(pdv2.value);
                            }
                            case 3: {
                                return -1;
                            }
                            case 2: {
                                return 1;
                            }
                        }
                        return Integer.MIN_VALUE;
                    }
                    case 3: {
                        switch (pdv2.dataPoint) {
                            case 0: 
                            case 1: 
                            case 2: {
                                return 1;
                            }
                            case 3: {
                                return 0;
                            }
                        }
                        return Integer.MIN_VALUE;
                    }
                    case 2: {
                        switch (pdv2.dataPoint) {
                            case 0: 
                            case 1: 
                            case 3: {
                                return -1;
                            }
                            case 2: {
                                return 0;
                            }
                        }
                        return Integer.MIN_VALUE;
                    }
                }
                return Integer.MIN_VALUE;
            }
            if (o instanceof Int64Value.Int64Comparable) {
                return this.asBigDecimal().compareTo(BigDecimal.valueOf(((Int64Value.Int64Comparable)o).asLong()));
            }
            if (o instanceof BigIntegerValue.BigIntegerComparable) {
                return this.pdv.compareTo(new BigDecimal(((BigIntegerValue.BigIntegerComparable)o).asBigInteger()));
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            if (this.pdv.isWholeNumber()) {
                try {
                    return this.pdv.convertPrimitive(BuiltInAtomicType.INTEGER, true, null).asAtomic().getSchemaComparable().hashCode();
                }
                catch (ValidationException e) {
                    return 12345678;
                }
            }
            return this.pdv.hashCode();
        }
    }
}

