/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;

public class XLibrary {
    private XProcRuntime runtime = null;
    private PipelineLibrary library = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public XLibrary(XProcRuntime xProcRuntime, PipelineLibrary pipelineLibrary) {
        this.runtime = xProcRuntime;
        this.library = pipelineLibrary;
    }

    public XPipeline getFirstPipeline() {
        QName qName = this.library.firstStep();
        return this.getPipeline(qName);
    }

    public QName getFirstPipelineType() {
        return this.library.firstStep();
    }

    public XPipeline getPipeline(QName qName) {
        Object object;
        DeclareStep declareStep = this.library.getDeclaration(qName);
        if (declareStep == null) {
            this.runtime.error(null, this.library.getNode(), "No step named " + qName + " in library.", null);
            return null;
        }
        XRootStep xRootStep = new XRootStep(this.runtime);
        if (declareStep.subpipeline().size() == 0) {
            SourceArtifact sourceArtifact;
            Port port;
            object = new Step(this.runtime, declareStep.getNode(), declareStep.getDeclaredType(), declareStep.getName());
            ((Step)object).setDeclaration(declareStep);
            String string = "XML-CALABASH-GENERATED-WRAPPER-PIPELINE";
            QName qName2 = new QName("", "XML-CALABASH-WRAPPER-TYPE");
            DeclareStep declareStep2 = new DeclareStep(this.runtime, declareStep.getNode(), string);
            for (Input port2 : declareStep.inputs()) {
                port = new Input(this.runtime, port2.getNode());
                port.setPort(port2.getPort());
                port.setPrimary(port2.getPrimary());
                port.setSequence(port2.getSequence());
                ((Input)port).setParameterInput(port2.getParameterInput());
                declareStep2.addInput((Input)port);
                sourceArtifact = new PipeNameBinding(this.runtime, port2.getNode());
                ((PipeNameBinding)sourceArtifact).setStep(string);
                ((PipeNameBinding)sourceArtifact).setPort(port.getPort());
                port2.addBinding((Binding)sourceArtifact);
                ((Step)object).addInput(port2);
            }
            for (Output output : declareStep.outputs()) {
                port = new Output(this.runtime, output.getNode());
                port.setPort(output.getPort());
                port.setPrimary(output.getPrimary());
                port.setSequence(output.getSequence());
                sourceArtifact = new Input(this.runtime, output.getNode());
                ((Port)sourceArtifact).setPort("|" + output.getPort());
                ((Port)sourceArtifact).setSequence(output.getSequence());
                declareStep2.addInput((Input)sourceArtifact);
                PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, output.getNode());
                pipeNameBinding.setStep(declareStep.getName());
                pipeNameBinding.setPort(output.getPort());
                ((EndPoint)sourceArtifact).addBinding(pipeNameBinding);
                declareStep2.addOutput((Output)port);
                ((Step)object).addOutput(output);
            }
            declareStep2.addStep((Step)object);
            declareStep2.setDeclaredType(qName2);
            this.runtime.declareStep(qName2, declareStep2);
            declareStep = declareStep2;
            declareStep.setup();
        } else {
            declareStep.setup();
        }
        object = new XPipeline(this.runtime, declareStep, xRootStep);
        if (this.runtime.getErrorCode() != null) {
            throw new XProcException(this.runtime.getErrorCode(), this.runtime.getErrorMessage());
        }
        ((XCompoundStep)object).instantiate(declareStep);
        return object;
    }
}

