/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

final class TinyCommentImpl
extends TinyNodeImpl {
    public TinyCommentImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    public final String getStringValue() {
        int start = this.tree.alpha[this.nodeNr];
        int len = this.tree.beta[this.nodeNr];
        if (len == 0) {
            return "";
        }
        char[] dest = new char[len];
        this.tree.commentBuffer.getChars(start, start + len, dest, 0);
        return new String(dest, 0, len);
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValue()));
    }

    public Value atomize() {
        return new StringValue(this.getStringValue());
    }

    public final int getNodeKind() {
        return 8;
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        out.comment(this.getStringValue(), 0, 0);
    }
}

