# SPDX-License-Identifier: Apache-2.0
# Copyright 2016 The Meson development team

from __future__ import annotations

import argparse
import subprocess
import os
import typing as T

parser = argparse.ArgumentParser()
parser.add_argument('input')
parser.add_argument('output')
parser.add_argument('type')
parser.add_argument('podir')
parser.add_argument('--msgfmt', default='msgfmt')
parser.add_argument('--datadirs', default='')
parser.add_argument('args', default=[], metavar='extra msgfmt argument', nargs='*')


def run(args: T.List[str]) -> int:
    options = parser.parse_args(args)
    env = None
    if options.datadirs:
        env = os.environ.copy()
        env.update({'GETTEXTDATADIRS': options.datadirs})
    return subprocess.call([options.msgfmt, '--' + options.type, '-d', options.podir,
                            '--template', options.input,  '-o', options.output] + options.args,
                           env=env)
