# Copyright 2025-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.1

EAPI=8

CRATES="
"

RUST_MIN_VER="1.89.0"

inherit cargo

DESCRIPTION="Jujutsu - an experimental version control system"
HOMEPAGE="https://www.jj-vcs.dev/"
SRC_URI="
	${CARGO_CRATE_URIS}
	https://github.com/jj-vcs/jj/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz
	mirror://gentoo/jj-cli-${PV}-crates.tar.xz
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD MIT MIT-0 MPL-2.0 Unicode-3.0 Unicode-DFS-2016
	WTFPL-2 ZLIB
"
SLOT="0"
KEYWORDS="~amd64"

QA_PREBUILT="/usr/bin/jj"

DOCS=(
	CHANGELOG.md
	GOVERNANCE.md
	README.md
	SECURITY.md
	docs/
	demos/
)

src_test() {
	local -a cargo_skip_tests=(
		# skip tests that fail in sandbox environment
		test_gpg::gpgsm_signing_roundtrip
		test_gpg::gpgsm_signing_roundtrip_explicit_key
	    test_gpg::gpgsm_unknown_key
	)

	local -a skip_params
	readarray -t skip_params < <(printf -- '--skip\n%s\n' "${cargo_skip_tests[@]}")

	cargo_src_test -- "${skip_params[@]}"
}

src_install() {
	pushd cli >/dev/null || die
	cargo_src_install
	popd >/dev/null || die

	dodoc -r "${DOCS[@]}"
}
