# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

CRATES="
	addr2line@0.24.2
	adler2@2.0.0
	aho-corasick@1.1.3
	allocator-api2@0.2.21
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	anyhow@1.0.98
	arrayvec@0.7.6
	async-channel@2.3.1
	async-task@4.7.1
	async-trait@0.1.88
	atomic-waker@1.1.2
	autocfg@1.4.0
	backtrace@0.3.74
	bitflags@2.9.0
	blocking@1.6.1
	bumpalo@3.17.0
	bytes@1.10.1
	c2rust-bitfields-derive@0.19.0
	c2rust-bitfields@0.19.0
	caps@0.5.5
	cassowary@0.3.0
	castaway@0.2.3
	cc@1.2.21
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chrono-tz-build@0.4.1
	chrono-tz@0.10.3
	chrono@0.4.41
	clap@4.5.37
	clap_builder@4.5.37
	clap_complete@4.5.48
	clap_derive@4.5.32
	clap_lex@0.7.4
	clap_mangen@0.2.26
	colorchoice@1.0.3
	comfy-table@7.1.4
	compact_str@0.8.1
	concurrent-queue@2.5.0
	console@0.15.11
	core-foundation-sys@0.8.7
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.12
	crossbeam-utils@0.8.21
	crossbeam@0.8.4
	crossterm@0.28.1
	crossterm_winapi@0.9.1
	csv-core@0.1.12
	csv@1.3.1
	darling@0.20.11
	darling_core@0.20.11
	darling_macro@0.20.11
	data-encoding@2.9.0
	derive_more-impl@2.0.1
	derive_more@2.0.1
	diff@0.1.13
	displaydoc@0.2.5
	dns-lookup@2.0.4
	downcast@0.11.0
	either@1.15.0
	encode_unicode@1.0.0
	encoding_rs@0.8.35
	encoding_rs_io@0.1.7
	enum-as-inner@0.6.1
	equivalent@1.0.2
	errno@0.3.11
	etcetera@0.8.0
	event-listener-strategy@0.5.4
	event-listener@5.4.0
	fastrand@2.3.0
	fixedbitset@0.5.7
	fnv@1.0.7
	foldhash@0.1.5
	form_urlencoded@1.2.1
	fragile@2.0.1
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-lite@2.6.0
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	futures@0.3.31
	getrandom@0.2.16
	getrandom@0.3.2
	gimli@0.31.1
	hashbrown@0.15.3
	heck@0.5.0
	hex-literal@0.4.1
	hickory-proto@0.24.4
	hickory-resolver@0.24.4
	home@0.5.9
	humantime@2.2.0
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.63
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.1
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.1
	icu_properties@1.5.1
	icu_properties_data@1.5.1
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	ident_case@1.0.1
	idna@1.0.3
	idna_adapter@1.2.0
	indexmap@2.9.0
	indoc@2.0.6
	insta@1.43.1
	instability@0.3.7
	ipconfig@0.3.2
	ipnet@2.11.0
	ipnetwork@0.21.1
	is_terminal_polyfill@1.70.1
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.15
	js-sys@0.3.77
	lazy_static@1.5.0
	libc@0.2.172
	libloading@0.8.6
	linked-hash-map@0.5.6
	linux-raw-sys@0.4.15
	linux-raw-sys@0.9.4
	litemap@0.7.4
	lock_api@0.4.12
	log@0.4.27
	lru-cache@0.1.2
	lru@0.12.5
	matchers@0.1.0
	maxminddb@0.25.0
	memchr@2.7.4
	memoffset@0.9.1
	miniz_oxide@0.8.8
	mio@1.0.3
	mockall@0.13.1
	mockall_derive@0.13.1
	nix@0.29.0
	nu-ansi-term@0.46.0
	num-traits@0.2.19
	object@0.36.7
	once_cell@1.21.3
	overload@0.1.1
	parking@2.2.1
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	parse-zoneinfo@0.3.1
	paste@1.0.15
	percent-encoding@2.3.1
	petgraph@0.7.1
	phf@0.11.3
	phf_codegen@0.11.3
	phf_generator@0.11.3
	phf_shared@0.11.3
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	piper@0.2.4
	ppv-lite86@0.2.21
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	pretty_assertions@1.4.1
	proc-macro2@1.0.95
	quote@1.0.40
	r-efi@5.2.0
	rand@0.8.5
	rand@0.9.1
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	ratatui@0.29.0
	redox_syscall@0.5.12
	regex-automata@0.1.10
	regex-automata@0.4.9
	regex-syntax@0.6.29
	regex-syntax@0.8.5
	regex@1.11.1
	resolv-conf@0.7.3
	roff@0.2.2
	rustc-demangle@0.1.24
	rustix@0.38.44
	rustix@1.0.7
	rustversion@1.0.20
	ryu@1.0.20
	scopeguard@1.2.0
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.140
	serde_spanned@0.6.8
	serde_with@3.12.0
	serde_with_macros@3.12.0
	sharded-slab@0.1.7
	shlex@1.3.0
	signal-hook-mio@0.2.4
	signal-hook-registry@1.4.5
	signal-hook@0.3.17
	similar@2.7.0
	siphasher@1.0.1
	slab@0.4.9
	smallvec@1.15.0
	socket2@0.5.9
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	strsim@0.11.1
	strum@0.26.3
	strum@0.27.1
	strum_macros@0.26.4
	strum_macros@0.27.1
	syn@1.0.109
	syn@2.0.101
	synstructure@0.13.2
	sys-locale@0.3.2
	terminal_size@0.4.2
	termtree@0.5.1
	test-case-core@3.3.1
	test-case-macros@3.3.1
	test-case@3.3.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.12
	thiserror@1.0.69
	thiserror@2.0.12
	thread_local@1.1.8
	tinystr@0.7.6
	tinyvec@1.9.0
	tinyvec_macros@0.1.1
	tokio-macros@2.5.0
	tokio-util@0.7.15
	tokio@1.44.2
	toml@0.8.22
	toml_datetime@0.6.9
	toml_edit@0.22.26
	tracing-attributes@0.1.28
	tracing-chrome@0.7.2
	tracing-core@0.1.33
	tracing-log@0.2.0
	tracing-serde@0.2.0
	tracing-subscriber@0.3.19
	tracing@0.1.41
	tun2@4.0.0
	unicode-ident@1.0.18
	unicode-segmentation@1.12.0
	unicode-truncate@1.1.0
	unicode-width@0.1.14
	unicode-width@0.2.0
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	utf8parse@0.2.2
	valuable@0.1.1
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	widestring@1.2.0
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.61.0
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.1
	windows-result@0.3.2
	windows-strings@0.4.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.7.9
	winreg@0.50.0
	wintun-bindings@0.7.31
	wit-bindgen-rt@0.39.0
	write16@1.0.0
	writeable@0.5.5
	yansi@1.0.1
	yoke-derive@0.7.5
	yoke@0.7.5
	zerocopy-derive@0.8.25
	zerocopy@0.8.25
	zerofrom-derive@0.1.6
	zerofrom@0.1.5
	zerovec-derive@0.10.3
	zerovec@0.10.4
"

RUST_MIN_VER="1.78"

inherit cargo fcaps

DESCRIPTION="A network diagnostic tool"
HOMEPAGE="https://trippy.cli.rs/ https://github.com/fujiapple852/trippy"
SRC_URI="
	https://github.com/fujiapple852/trippy/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD ISC MIT Unicode-3.0 WTFPL-2 ZLIB"
SLOT="0"
KEYWORDS="amd64"
IUSE="suid"

FILECAPS=( cap_net_raw+p usr/bin/trip )

QA_FLAGS_IGNORED="usr/bin/trip"

src_install() {
	cargo_src_install --path crates/trippy

	dodoc README.md CHANGELOG.md

	if use suid; then
		fperms u+s usr/bin/trip
	fi
}
