# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.6.6.9999
#hackport: flags: -two,+mtl,-generic-deriving

CABAL_FEATURES="lib profile haddock hoogle hscolour"
# break circular dependencies:
# https://github.com/gentoo-haskell/gentoo-haskell/issues/810
CABAL_FEATURES+=" nocabaldep"
inherit haskell-cabal

DESCRIPTION="A small compatibility shim for the transformers library"
HOMEPAGE="https://github.com/ekmett/transformers-compat/"
SRC_URI="https://hackage.haskell.org/package/${P}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE=""

RDEPEND=">=dev-haskell/fail-4.9:=[profile?] <dev-haskell/fail-4.10:=[profile?]
	>=dev-haskell/mtl-2.1:=[profile?]
	>=dev-haskell/transformers-0.3:=[profile?]
	>=dev-lang/ghc-7.8.2:=
"
DEPEND="${RDEPEND}
"

src_configure() {
	local tf3_arg=()

	if has_version '=dev-haskell/transformers-0.3*'; then
		tf3_arg+=(--flag=three)
	else
		tf3_arg+=(--flag=-three)
	fi

	local tf4_arg=()

	if has_version '=dev-haskell/transformers-0.4*'; then
		tf4_arg+=(--flag=four)
	else
		tf4_arg+=(--flag=-four)
	fi

	local tf5_arg=()

	if has_version '=dev-haskell/transformers-0.5*'; then
		if has_version '>dev-haskell/transformers-0.5.3'; then
			tf5_arg+=(--flag=-five)
		else
			tf5_arg+=(--flag=five)
		fi
	else
		tf5_arg+=(--flag=-five)
	fi

	haskell-cabal_src_configure \
		--flag=-generic-deriving \
		--flag=mtl \
		--flag=-two \
		${tf3_arg[@]} \
		${tf4_arg[@]} \
		${tf5_arg[@]}
}
