#ifndef PLOTPROPERTIESWINDOW_H
#define PLOTPROPERTIESWINDOW_H

#include <string>

#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/entry.h>
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/scale.h>
#include <gtkmm/window.h>

#include <functional>

class XYPlot;

class PlotPropertiesWindow : public Gtk::Window {
 public:
  PlotPropertiesWindow(XYPlot& plot, const std::string& title);
  ~PlotPropertiesWindow() {}

  std::function<void()> OnChangesApplied;

 private:
  void onApplyClicked();
  void onCloseClicked();
  void onExportClicked();

  void onVRangeChanged() {
    _vRangeMinEntry.set_sensitive(_specifiedVRangeButton.get_active());
    _vRangeMaxEntry.set_sensitive(_specifiedVRangeButton.get_active());
  }

  void onHRangeChanged() {
    _hRangeMinEntry.set_sensitive(!_automaticHRangeButton.get_active());
    _hRangeMaxEntry.set_sensitive(!_automaticHRangeButton.get_active());
  }

  void initVRangeWidgets();
  void initHRangeWidgets();
  void initOptionsWidgets();
  void initAxesDescriptionWidgets();

  void updateHMinMaxEntries();
  void updateVMinMaxEntries();

  XYPlot& _plot;

  Gtk::Box _bottomButtonBox;
  Gtk::Box _topVBox{Gtk::Orientation::VERTICAL};
  Gtk::Box _framesHBox;
  Gtk::Box _framesRightVBox{Gtk::Orientation::VERTICAL};

  Gtk::Entry _titleEntry;

  Gtk::Button _applyButton, _exportButton, _closeButton;

  Gtk::Frame _vRangeFrame;
  Gtk::Box _vRangeBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _minMaxVRangeButton, _winsorizedVRangeButton,
      _specifiedVRangeButton;
  Gtk::Label _vRangeMinLabel, _vRangeMaxLabel;
  Gtk::Entry _vRangeMinEntry, _vRangeMaxEntry;

  Gtk::Frame _hRangeFrame;
  Gtk::Box _hRangeBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _automaticHRangeButton;
  Gtk::Label _hRangeMinLabel, _hRangeMaxLabel;
  Gtk::Entry _hRangeMinEntry, _hRangeMaxEntry;

  Gtk::Frame _xOptionsFrame;
  Gtk::Box _xOptionsBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _xLogScaleButton;

  Gtk::Frame _yOptionsFrame;
  Gtk::Box _yOptionsBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _yNormalOptionsButton, _yLogScaleButton,
      _yZeroSymmetricButton;

  Gtk::Frame _axesDescriptionFrame;
  Gtk::Box _axesDescriptionBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _hAxisDescriptionButton, _vAxisDescriptionButton;
  Gtk::Entry _hAxisDescriptionEntry, _vAxisDescriptionEntry;

  Gtk::CheckButton _showAxes, _showAxisDescriptionsButton;
  std::unique_ptr<Gtk::FileChooserDialog> dialog_;
};

#endif  // PLOTPROPERTIESWINDOW_H
