// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

const EnterpriseIcon = (props: any) => (
    <svg
        xmlns='http://www.w3.org/2000/svg'
        xmlSpace='preserve'
        width={props.width}
        height={props.height}
        style={props.style}
        version='1.1'
        shapeRendering='geometricPrecision'
        textRendering='geometricPrecision'
        imageRendering='optimizeQuality'
        fillRule='evenodd'
        clipRule='evenodd'
        viewBox='0 0 2743 2009'
        xmlnsXlink='http://www.w3.org/1999/xlink'>
        <title>{props.title}</title>
        <g id='Layer_x0020_1'>
            <metadata id='CorelCorpID_0Corel-Layer' />
            <path
                fill={props.fill}
                d='M1502 473c-88,0 -164,47 -205,118l-410 0c-178,0 -333,-99 -414,-245l-63 -110c364,0 728,0 1092,0 175,0 328,96 409,237 158,42 316,84 473,127l-291 503 -436 165 -155 269 -274 -473 -273 0 546 945 329 -569 437 -165 476 -824 -687 -184c-151,-167 -311,-263 -541,-267l-1515 0 275 476c134,230 377,356 626,352l396 0c41,70 117,118 205,118 130,0 236,-106 236,-237 0,-130 -106,-236 -236,-236z'
            />
        </g>
    </svg>
);

export default EnterpriseIcon;
