import * as React from 'react';
/**
 * @ignore - internal component.
 */
var Context = /*#__PURE__*/React.createContext(null);
if (process.env.NODE_ENV !== 'production') {
  Context.displayName = 'TabsContext';
}
export function useTabsContext() {
  var context = React.useContext(Context);
  if (context == null) {
    throw new Error('No TabsContext provided');
  }
  return context;
}
export default Context;