import { LabelName } from "allure-js-commons";
import { extractMetadataFromString } from "allure-js-commons/sdk";
import { getPosixPath, getRelativePath, includedInTestPlan } from "allure-js-commons/sdk/reporter";
export const getSuitePath = (task) => {
    const path = [];
    let currentSuite = task.suite;
    while (currentSuite) {
        // root suite has no name and shouldn't be included to the path
        if (!currentSuite.name) {
            break;
        }
        path.unshift(currentSuite.name);
        currentSuite = currentSuite.suite;
    }
    return path;
};
export const getTestMetadata = (task) => {
    const suitePath = getSuitePath(task);
    const relativeTestPath = getPosixPath(getRelativePath(task.file.filepath));
    const { cleanTitle, labels, links } = extractMetadataFromString(task.name);
    return {
        specPath: relativeTestPath,
        name: cleanTitle || task.name,
        suitePath,
        fullName: `${relativeTestPath}#${suitePath.concat(cleanTitle).join(" ")}`,
        labels,
        links,
    };
};
export const existsInTestPlan = (task, testPlan) => {
    if (!testPlan) {
        return true;
    }
    const { fullName, labels } = getTestMetadata(task);
    const { value: id } = labels.find(({ name }) => name === LabelName.ALLURE_ID) ?? {};
    return includedInTestPlan(testPlan, { fullName, id });
};
//# sourceMappingURL=utils.js.map