// copyright: Copyright (c) 2024 Lowell D. Thomas, all rights reserved<br>
//   license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)<br>
//
// Generated by apg-js, Version 4.4.0 [apg-js](https://github.com/ldthomas/apg-js)
const Grammar = function grammar(){
  // ```
  // SUMMARY
  //      rules = 6
  //       udts = 0
  //    opcodes = 24
  //        ---   ABNF original opcodes
  //        ALT = 0
  //        CAT = 4
  //        REP = 3
  //        RNM = 11
  //        TLS = 0
  //        TBS = 3
  //        TRG = 0
  //        ---   SABNF superset opcodes
  //        UDT = 0
  //        AND = 1
  //        NOT = 2
  //        BKA = 0
  //        BKN = 0
  //        BKR = 0
  //        ABG = 0
  //        AEN = 0
  // characters = [97 - 99]
  // ```
  /* OBJECT IDENTIFIER (for internal parser use) */
  this.grammarObject = 'grammarObject';

  /* RULES */
  this.rules = [];
  this.rules[0] = { name: 'S', lower: 's', index: 0, isBkr: false };
  this.rules[1] = { name: 'AB', lower: 'ab', index: 1, isBkr: false };
  this.rules[2] = { name: 'BC', lower: 'bc', index: 2, isBkr: false };
  this.rules[3] = { name: 'a', lower: 'a', index: 3, isBkr: false };
  this.rules[4] = { name: 'b', lower: 'b', index: 4, isBkr: false };
  this.rules[5] = { name: 'c', lower: 'c', index: 5, isBkr: false };

  /* UDTS */
  this.udts = [];

  /* OPCODES */
  /* S */
  this.rules[0].opcodes = [];
  this.rules[0].opcodes[0] = { type: 2, children: [1,6,8,9] };// CAT
  this.rules[0].opcodes[1] = { type: 12 };// AND
  this.rules[0].opcodes[2] = { type: 2, children: [3,4] };// CAT
  this.rules[0].opcodes[3] = { type: 4, index: 1 };// RNM(AB)
  this.rules[0].opcodes[4] = { type: 13 };// NOT
  this.rules[0].opcodes[5] = { type: 4, index: 4 };// RNM(b)
  this.rules[0].opcodes[6] = { type: 3, min: 0, max: Infinity };// REP
  this.rules[0].opcodes[7] = { type: 4, index: 3 };// RNM(a)
  this.rules[0].opcodes[8] = { type: 4, index: 2 };// RNM(BC)
  this.rules[0].opcodes[9] = { type: 13 };// NOT
  this.rules[0].opcodes[10] = { type: 4, index: 5 };// RNM(c)

  /* AB */
  this.rules[1].opcodes = [];
  this.rules[1].opcodes[0] = { type: 2, children: [1,2,4] };// CAT
  this.rules[1].opcodes[1] = { type: 4, index: 3 };// RNM(a)
  this.rules[1].opcodes[2] = { type: 3, min: 0, max: 1 };// REP
  this.rules[1].opcodes[3] = { type: 4, index: 1 };// RNM(AB)
  this.rules[1].opcodes[4] = { type: 4, index: 4 };// RNM(b)

  /* BC */
  this.rules[2].opcodes = [];
  this.rules[2].opcodes[0] = { type: 2, children: [1,2,4] };// CAT
  this.rules[2].opcodes[1] = { type: 4, index: 4 };// RNM(b)
  this.rules[2].opcodes[2] = { type: 3, min: 0, max: 1 };// REP
  this.rules[2].opcodes[3] = { type: 4, index: 2 };// RNM(BC)
  this.rules[2].opcodes[4] = { type: 4, index: 5 };// RNM(c)

  /* a */
  this.rules[3].opcodes = [];
  this.rules[3].opcodes[0] = { type: 6, string: [97] };// TBS

  /* b */
  this.rules[4].opcodes = [];
  this.rules[4].opcodes[0] = { type: 6, string: [98] };// TBS

  /* c */
  this.rules[5].opcodes = [];
  this.rules[5].opcodes[0] = { type: 6, string: [99] };// TBS

  // The `toString()` function will display the original grammar file(s) that produced these opcodes.
  this.toString = function toString(){
    let str = "";
    str += "; It is known that the language the language L = {a^nb^nc^n | n >= 1} is not context free.\n";
    str += "; However, with the use of the look ahead operators we can construct a grammar\n";
    str += "; that accepts those phrases and only those phrases.\n";
    str += "S = &(AB !b) *a BC !c\n";
    str += "AB = a [AB] b\n";
    str += "BC = b [BC] c\n";
    str += "a = %s\"a\"\n";
    str += "b = %s\"b\"\n";
    str += "c = %s\"c\"\n";
    return str;
  }
}
