/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Evangelos Ribeiro Tzaras <devrtz@fortysixandtwo.eu>
 */

#include "gio/gio.h"
#define LIBCELLBROADCAST_USE_UNSTABLE_API
#include <libcellbroadcast.h>

static void
test_simple_init (void)
{
  g_autoptr (GError) err = NULL;
  gboolean ok;

  ok = lcb_init (&err);
  g_assert_no_error (err);
  g_assert_true (ok);

  g_assert_true (lcb_is_initted ());

  lcb_uninit ();
  g_assert_false (lcb_is_initted ());
}

int
main (int argc, char *argv[])
{
  g_autoptr (GTestDBus) test_dbus = NULL;

  test_dbus = g_test_dbus_new (G_TEST_DBUS_NONE);
  g_test_dbus_up (test_dbus);
  g_test_init (&argc, &argv, NULL);

  g_test_add_func ("/lcb/init/simple", test_simple_init);

  return g_test_run ();
}
