// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PatchConfigReader is a Reader for the PatchConfig structure.
type PatchConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewPatchConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPatchConfigBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPatchConfigForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPatchConfigFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /config] PatchConfig", response, response.Code())
	}
}

// NewPatchConfigOK creates a PatchConfigOK with default headers values
func NewPatchConfigOK() *PatchConfigOK {
	return &PatchConfigOK{}
}

/*
PatchConfigOK describes a response with status code 200, with default header values.

Success
*/
type PatchConfigOK struct {
}

// IsSuccess returns true when this patch config o k response has a 2xx status code
func (o *PatchConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this patch config o k response has a 3xx status code
func (o *PatchConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch config o k response has a 4xx status code
func (o *PatchConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch config o k response has a 5xx status code
func (o *PatchConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this patch config o k response a status code equal to that given
func (o *PatchConfigOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the patch config o k response
func (o *PatchConfigOK) Code() int {
	return 200
}

func (o *PatchConfigOK) Error() string {
	return fmt.Sprintf("[PATCH /config][%d] patchConfigOK", 200)
}

func (o *PatchConfigOK) String() string {
	return fmt.Sprintf("[PATCH /config][%d] patchConfigOK", 200)
}

func (o *PatchConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchConfigBadRequest creates a PatchConfigBadRequest with default headers values
func NewPatchConfigBadRequest() *PatchConfigBadRequest {
	return &PatchConfigBadRequest{}
}

/*
PatchConfigBadRequest describes a response with status code 400, with default header values.

Bad configuration parameters
*/
type PatchConfigBadRequest struct {
	Payload models.Error
}

// IsSuccess returns true when this patch config bad request response has a 2xx status code
func (o *PatchConfigBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch config bad request response has a 3xx status code
func (o *PatchConfigBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch config bad request response has a 4xx status code
func (o *PatchConfigBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch config bad request response has a 5xx status code
func (o *PatchConfigBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this patch config bad request response a status code equal to that given
func (o *PatchConfigBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the patch config bad request response
func (o *PatchConfigBadRequest) Code() int {
	return 400
}

func (o *PatchConfigBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /config][%d] patchConfigBadRequest %s", 400, payload)
}

func (o *PatchConfigBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /config][%d] patchConfigBadRequest %s", 400, payload)
}

func (o *PatchConfigBadRequest) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchConfigBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewPatchConfigForbidden creates a PatchConfigForbidden with default headers values
func NewPatchConfigForbidden() *PatchConfigForbidden {
	return &PatchConfigForbidden{}
}

/*
PatchConfigForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PatchConfigForbidden struct {
}

// IsSuccess returns true when this patch config forbidden response has a 2xx status code
func (o *PatchConfigForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch config forbidden response has a 3xx status code
func (o *PatchConfigForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch config forbidden response has a 4xx status code
func (o *PatchConfigForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch config forbidden response has a 5xx status code
func (o *PatchConfigForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this patch config forbidden response a status code equal to that given
func (o *PatchConfigForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the patch config forbidden response
func (o *PatchConfigForbidden) Code() int {
	return 403
}

func (o *PatchConfigForbidden) Error() string {
	return fmt.Sprintf("[PATCH /config][%d] patchConfigForbidden", 403)
}

func (o *PatchConfigForbidden) String() string {
	return fmt.Sprintf("[PATCH /config][%d] patchConfigForbidden", 403)
}

func (o *PatchConfigForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchConfigFailure creates a PatchConfigFailure with default headers values
func NewPatchConfigFailure() *PatchConfigFailure {
	return &PatchConfigFailure{}
}

/*
PatchConfigFailure describes a response with status code 500, with default header values.

Recompilation failed
*/
type PatchConfigFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this patch config failure response has a 2xx status code
func (o *PatchConfigFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch config failure response has a 3xx status code
func (o *PatchConfigFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch config failure response has a 4xx status code
func (o *PatchConfigFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch config failure response has a 5xx status code
func (o *PatchConfigFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this patch config failure response a status code equal to that given
func (o *PatchConfigFailure) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the patch config failure response
func (o *PatchConfigFailure) Code() int {
	return 500
}

func (o *PatchConfigFailure) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /config][%d] patchConfigFailure %s", 500, payload)
}

func (o *PatchConfigFailure) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /config][%d] patchConfigFailure %s", 500, payload)
}

func (o *PatchConfigFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchConfigFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}
