/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

import { IDisposable } from '../../../../../../base/common/lifecycle.js';
import { ChatTreeItem, IChatCodeBlockInfo } from '../../chat.js';
import { IChatRendererContent, IChatRequestViewModel, IChatResponseViewModel } from '../../../common/model/chatViewModel.js';
import { CodeBlockModelCollection } from '../../../common/widget/codeBlockModelCollection.js';
import { DiffEditorPool, EditorPool } from './chatContentCodePools.js';
import { IObservable } from '../../../../../../base/common/observable.js';
import { Event } from '../../../../../../base/common/event.js';

export interface IChatContentPart extends IDisposable {
	domNode: HTMLElement | undefined;

	/**
	 * Used to indicate a part's ownership of a code block.
	 */
	codeblocksPartId?: string;

	/**
	 * Codeblocks that were rendered by this part into CodeBlockModelCollection.
	 */
	codeblocks?: IChatCodeBlockInfo[];

	/**
	 * Returns true if the other content is equivalent to what is already rendered in this content part.
	 * Returns false if a rerender is needed.
	 * followingContent is all the content that will be rendered after this content part (to support progress messages' behavior).
	 */
	hasSameContent(other: IChatRendererContent, followingContent: IChatRendererContent[], element: ChatTreeItem): boolean;

	/**
	 * Called when the content part is mounted to the DOM after being detached
	 * due to virtualization.
	 */
	onDidRemount?(): void;

	addDisposable?(disposable: IDisposable): void;
}

export interface IChatContentPartRenderContext {
	readonly element: IChatRequestViewModel | IChatResponseViewModel;
	readonly elementIndex: number;
	readonly container: HTMLElement;
	readonly content: ReadonlyArray<IChatRendererContent>;
	readonly contentIndex: number;
	readonly editorPool: EditorPool;
	readonly codeBlockStartIndex: number;
	readonly treeStartIndex: number;
	readonly diffEditorPool: DiffEditorPool;
	readonly codeBlockModelCollection: CodeBlockModelCollection;
	readonly currentWidth: IObservable<number>;
	readonly onDidChangeVisibility: Event<boolean>;
}
