// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Covenant.API.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class HttpListener
    {
        /// <summary>
        /// Initializes a new instance of the HttpListener class.
        /// </summary>
        public HttpListener()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the HttpListener class.
        /// </summary>
        /// <param name="status">Possible values include: 'Uninitialized',
        /// 'Active', 'Stopped'</param>
        public HttpListener(bool useSSL, IList<string> urls, string name, string guid, string description, string bindAddress, int bindPort, IList<string> connectAddresses, int connectPort, int profileId, int listenerTypeId, ListenerStatus status, string sslCertificate = default(string), string sslCertificatePassword = default(string), string sslCertHash = default(string), int? id = default(int?), Profile profile = default(Profile), ListenerType listenerType = default(ListenerType), string covenantToken = default(string), System.DateTime? startTime = default(System.DateTime?))
        {
            UseSSL = useSSL;
            SslCertificate = sslCertificate;
            SslCertificatePassword = sslCertificatePassword;
            SslCertHash = sslCertHash;
            Urls = urls;
            Id = id;
            Name = name;
            Guid = guid;
            Description = description;
            BindAddress = bindAddress;
            BindPort = bindPort;
            ConnectAddresses = connectAddresses;
            ConnectPort = connectPort;
            ProfileId = profileId;
            Profile = profile;
            ListenerTypeId = listenerTypeId;
            ListenerType = listenerType;
            Status = status;
            CovenantToken = covenantToken;
            StartTime = startTime;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "useSSL")]
        public bool UseSSL { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "sslCertificate")]
        public string SslCertificate { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "sslCertificatePassword")]
        public string SslCertificatePassword { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "sslCertHash")]
        public string SslCertHash { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "urls")]
        public IList<string> Urls { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public int? Id { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "guid")]
        public string Guid { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "description")]
        public string Description { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "bindAddress")]
        public string BindAddress { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "bindPort")]
        public int BindPort { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "connectAddresses")]
        public IList<string> ConnectAddresses { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "connectPort")]
        public int ConnectPort { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "profileId")]
        public int ProfileId { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "profile")]
        public Profile Profile { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "listenerTypeId")]
        public int ListenerTypeId { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "listenerType")]
        public ListenerType ListenerType { get; set; }

        /// <summary>
        /// Gets or sets possible values include: 'Uninitialized', 'Active',
        /// 'Stopped'
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public ListenerStatus Status { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "covenantToken")]
        public string CovenantToken { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "startTime")]
        public System.DateTime? StartTime { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Urls == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Urls");
            }
            if (Name == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Name");
            }
            if (Guid == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Guid");
            }
            if (Description == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Description");
            }
            if (BindAddress == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "BindAddress");
            }
            if (ConnectAddresses == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "ConnectAddresses");
            }
            if (Name != null)
            {
                if (Name.Length > 100)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Name", 100);
                }
                if (Name.Length < 0)
                {
                    throw new ValidationException(ValidationRules.MinLength, "Name", 0);
                }
            }
            if (Guid != null)
            {
                if (Guid.Length > 100)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Guid", 100);
                }
                if (Guid.Length < 0)
                {
                    throw new ValidationException(ValidationRules.MinLength, "Guid", 0);
                }
                if (!System.Text.RegularExpressions.Regex.IsMatch(Guid, "^[a-zA-Z0-9]*$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "Guid", "^[a-zA-Z0-9]*$");
                }
            }
            if (BindAddress != null)
            {
                if (!System.Text.RegularExpressions.Regex.IsMatch(BindAddress, "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "BindAddress", "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
                }
            }
            if (BindPort > 65535)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "BindPort", 65535);
            }
            if (BindPort < 1)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "BindPort", 1);
            }
            if (ConnectPort > 65535)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "ConnectPort", 65535);
            }
            if (ConnectPort < 1)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "ConnectPort", 1);
            }
        }
    }
}
