/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundleShapeAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class PublisherUtil {
    public static IInstallableUnit createBundleIU(IArtifactKey artifactKey, File bundleFile) {
        BundleDescription bundleDescription = BundlesAction.createBundleDescriptionIgnoringExceptions((File)bundleFile);
        if (bundleDescription == null) {
            return null;
        }
        PublisherInfo info = new PublisherInfo();
        Version version = Version.create((String)bundleDescription.getVersion().toString());
        AdviceFileAdvice advice = new AdviceFileAdvice(bundleDescription.getSymbolicName(), version, IPath.fromOSString((String)bundleFile.getAbsolutePath()), AdviceFileAdvice.BUNDLE_ADVICE_FILE);
        if (advice.containsAdvice()) {
            info.addAdvice((IPublisherAdvice)advice);
        }
        String shape = bundleFile.isDirectory() ? "dir" : "jar";
        info.addAdvice((IPublisherAdvice)new BundleShapeAdvice(bundleDescription.getSymbolicName(), version, shape));
        return BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)artifactKey, (IPublisherInfo)info);
    }
}

