/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.model;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class AbstractJdbcDriver
implements Driver {
    private final Logger rootLogger = Logger.getLogger(this.getClass().getName());
    private final String driverUrlPrefix;

    public AbstractJdbcDriver(String driverUrlPrefix) {
        this.driverUrlPrefix = driverUrlPrefix;
    }

    public String getDriverUrlPrefix() {
        return this.driverUrlPrefix;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.toLowerCase().startsWith(this.driverUrlPrefix);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        this.validateConnection(url, info);
        return this.connectImpl(url, info);
    }

    protected abstract Connection connectImpl(String var1, Properties var2) throws SQLException;

    protected void validateConnection(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            throw new SQLException("Invalid URL: " + url + ", expected prefix '" + this.getDriverUrlPrefix() + "'");
        }
    }

    @Override
    public Logger getParentLogger() {
        return this.rootLogger;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }
}

