/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DBNDatabaseDynamicItem
extends DBNDatabaseNode {
    private DBSObject object;

    public DBNDatabaseDynamicItem(DBNDatabaseNode parent, DBSObject object) {
        super(parent);
        this.object = object;
    }

    @Override
    public boolean isDisposed() {
        return this.object == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.object = null;
        super.dispose(reflect);
    }

    @Override
    @NotNull
    public DBXTreeNode getMeta() {
        DBNNode node = this.getParentNode();
        while (node != null) {
            if (node instanceof DBNDatabaseItem) {
                DBNDatabaseItem item = (DBNDatabaseItem)node;
                return item.getMeta();
            }
            node = node.getParentNode();
        }
        throw new IllegalStateException("Dynamic node without parent item node (" + String.valueOf(this) + ")");
    }

    @Override
    public boolean allowsChildren() {
        return !this.isDisposed() && this.hasDynamicStructChildren();
    }

    @Override
    public boolean isDynamicStructObject() {
        return this.getObject() instanceof DBSTypedObject;
    }

    @Override
    protected boolean reloadObject(DBRProgressMonitor monitor, DBSObject newObject) {
        return false;
    }

    @Override
    @Nullable
    public DBSObject getObject() {
        return this.object;
    }

    @Override
    public Object getValueObject() {
        return this.object;
    }

    @Override
    public boolean isPersisted() {
        return this.object != null && this.object.isPersisted();
    }

    @Override
    public final boolean isManageable() {
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return this.object == null ? super.toString() : this.object.toString();
    }
}

