/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.locks.table;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockItem;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

public class LockTable
extends DatabaseObjectListControl<DBAServerLock> {
    private DBAServerLockManager<DBAServerLock, DBAServerLockItem> lockManager;
    private static IStructuredContentProvider CONTENT_PROVIDER = new TreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public LockTable(Composite parent, int style, IWorkbenchSite site, DBAServerLockManager<DBAServerLock, DBAServerLockItem> lockManager) {
        super(parent, style, site, (IContentProvider)CONTENT_PROVIDER);
        this.lockManager = lockManager;
    }

    public DBAServerLockManager<DBAServerLock, DBAServerLockItem> getLockManager() {
        return this.lockManager;
    }

    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        return "Locks/" + this.lockManager.getDataSource().getContainer().getDriver().getId();
    }

    protected int getDataLoadTimeout() {
        return 20000;
    }

    protected LoadingJob<Collection<DBAServerLock>> createLoadService(boolean forUpdate) {
        return LoadingJob.createService((ILoadService)new LoadLocksService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
    }

    public LoadingJob<Void> createAlterService(DBAServerLock lock, Map<String, Object> options) {
        return LoadingJob.createService((ILoadService)new KillSessionByLockService(lock, options), (ILoadVisualizer)new ObjectListControl.ObjectActionVisualizer((ObjectListControl)this));
    }

    public void init(DBAServerLockManager<DBAServerLock, DBAServerLockItem> lockManager) {
        this.lockManager = lockManager;
    }

    private class KillSessionByLockService
    extends DatabaseLoadService<Void> {
        private final DBAServerLock lock;
        private final Map<String, Object> options;

        protected KillSessionByLockService(DBAServerLock lock, Map<String, Object> options) {
            super("Kill session by lock", LockTable.this.lockManager.getDataSource());
            this.lock = lock;
            this.options = options;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Void evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCExecutionContext isolatedContext = LockTable.this.lockManager.getDataSource().getDefaultInstance().openIsolatedContext(monitor, "View locks", null);){
                    block21: {
                        Throwable throwable2 = null;
                        Object var6_10 = null;
                        DBCSession session = isolatedContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Kill server session by lock");
                        try {
                            LockTable.this.lockManager.alterSession(session, this.lock, this.options);
                            if (session == null) break block21;
                        }
                        catch (Throwable throwable3) {
                            try {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                        session.close();
                    }
                    return null;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }

    private class LoadLocksService
    extends DatabaseLoadService<Collection<DBAServerLock>> {
        protected LoadLocksService() {
            super("Load locks", LockTable.this.lockManager.getDataSource());
        }

        /*
         * Loose catch block
         */
        public Collection<DBAServerLock> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCExecutionContext isolatedContext = LockTable.this.lockManager.getDataSource().getDefaultInstance().openIsolatedContext(monitor, "View Locks", null);){
                    Collection<DBAServerLock> collection;
                    DBCSession session;
                    Throwable throwable2;
                    block21: {
                        throwable2 = null;
                        Object var6_10 = null;
                        session = isolatedContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Retrieve server locks");
                        collection = LockTable.this.lockManager.getLocks(session, null).values();
                        if (session == null) break block21;
                        session.close();
                    }
                    return collection;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }
}

