/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import java.util.Collection;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;

public class Partition {
    protected Column column;
    protected Expression value;

    public Partition() {
    }

    public Partition(Column column, Expression value) {
        this.column = column;
        this.value = value;
    }

    public static void appendPartitionsTo(StringBuilder builder, Collection<Partition> partitions) {
        int j = 0;
        for (Partition partition : partitions) {
            partition.appendTo(builder, j);
            ++j;
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = Objects.requireNonNull(column);
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = Objects.requireNonNull(value);
    }

    void appendTo(StringBuilder builder, int j) {
        if (j > 0) {
            builder.append(", ");
        }
        builder.append(this.column.getColumnName());
        if (this.value != null) {
            builder.append(" = ").append(this.value);
        }
    }
}

