/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ocient.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.ocient.model.plan.OcientPlanNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OcientPlanNodeJson
extends OcientPlanNode
implements DBPPropertySource {
    private OcientPlanNodeJson parent;
    private String name;
    private JsonObject object;
    private Map<String, String> nodeProps = new LinkedHashMap<String, String>();
    private List<OcientPlanNodeJson> nested = new ArrayList<OcientPlanNodeJson>();

    public OcientPlanNodeJson(OcientPlanNodeJson parent, String name, JsonObject object) {
        this.parent = parent;
        this.name = name;
        this.object = object;
        this.parseObject(object);
    }

    public OcientPlanNodeJson(OcientPlanNodeJson parent, Map<String, String> attributes) {
        this.parent = parent;
        this.nodeProps.putAll(attributes);
    }

    public Map<String, String> getNodeProps() {
        return this.nodeProps;
    }

    private void parseObject(JsonObject object) {
        for (Map.Entry prop : object.entrySet()) {
            String propName = (String)prop.getKey();
            JsonElement value = (JsonElement)prop.getValue();
            if (value instanceof JsonObject) {
                this.addNested(propName, (JsonObject)value);
                continue;
            }
            if (value instanceof JsonArray) {
                boolean isProp = false;
                int itemIndex = 0;
                for (JsonElement item : (JsonArray)value) {
                    if (item instanceof JsonObject) {
                        this.addNested(propName + "#" + ++itemIndex, (JsonObject)item);
                        continue;
                    }
                    isProp = true;
                    break;
                }
                if (!isProp) continue;
                this.nodeProps.put(propName, value.toString());
                continue;
            }
            if ("type".equals(propName)) {
                this.name = value.getAsString();
            }
            if ("totalCost".equals(propName)) {
                Double cost = Double.parseDouble(value.getAsString());
                String strValue = Double.toString(cost / 1000.0) + " seconds";
                this.nodeProps.put(propName, strValue);
                continue;
            }
            if ("indexMemUsage".equals(propName) || "queryMemUsage".equals(propName)) {
                Double cost = Double.parseDouble(value.getAsString());
                String strValue = Double.toString(cost / 1.0E9) + " GB";
                this.nodeProps.put(propName, strValue);
                continue;
            }
            this.nodeProps.put(propName, value.getAsString());
        }
    }

    private void addNested(String name, JsonObject value) {
        if (this.nested == null) {
            this.nested = new ArrayList<OcientPlanNodeJson>();
        }
        this.nested.add(new OcientPlanNodeJson(this, name, value));
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.name;
    }

    @Property(order=1, viewable=true)
    public String getNodeName() {
        return this.nodeProps.get("id");
    }

    @Property(order=10, viewable=true)
    public Number getNodeCost() {
        String readCost = this.nodeProps.get("cost");
        return CommonUtils.toDouble((Object)readCost);
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    @Property(order=11, viewable=true)
    public Number getNodeRowCount() {
        String rowCount = this.nodeProps.get("outputCardinality");
        return CommonUtils.toLong((Object)rowCount);
    }

    public OcientPlanNodeJson getParent() {
        return this.parent;
    }

    public Collection<OcientPlanNodeJson> getNested() {
        return this.nested;
    }

    public Object getProperty(String name) {
        return this.nodeProps.get(name);
    }

    public String toString() {
        return this.object == null ? this.nodeProps.toString() : this.object.toString();
    }

    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.nodeProps.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.nodeProps.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        return this.nodeProps.get(id.toString());
    }

    public boolean isPropertySet(@NotNull String id) {
        return this.nodeProps.containsKey(id.toString());
    }

    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }
}

