/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardProviderDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemConfigurationDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardManagerDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardManagerDialog";
    private DashboardItemConfiguration selectedDashboard;
    private Button copyButton;
    private Button editButton;
    private Button deleteButton;
    private DashboardTreeViewer treeViewer;

    public DashboardManagerDialog(Shell shell) {
        super(shell, UIDashboardMessages.dialog_dashboard_manager_title, null);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(300, 300);
        Composite dialogArea = super.createDialogArea(parent);
        Composite group = UIUtils.createPlaceholder((Composite)dialogArea, (int)2);
        group.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new DashboardTreeViewer(group);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.getTree().setHeaderVisible(true);
        UIUtils.createTreeColumn((Tree)this.treeViewer.getTree(), (int)16384, (String)UIDashboardMessages.dialog_dashboard_manager_treecolumn_name);
        final HashMap parentMap = new HashMap();
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                List result = null;
                if (parentElement instanceof List) {
                    List list;
                    result = list = (List)parentElement;
                } else if (parentElement instanceof DashboardProviderDescriptor) {
                    DashboardProviderDescriptor dpd = (DashboardProviderDescriptor)parentElement;
                    result = dpd.isDatabaseRequired() ? DashboardRegistry.getInstance().getAllSupportedSources(dpd) : DashboardRegistry.getInstance().getDashboardItems(dpd, null, false);
                } else if (parentElement instanceof DBPDataSourceProviderDescriptor) {
                    DBPDataSourceProviderDescriptor dspd = (DBPDataSourceProviderDescriptor)parentElement;
                    result = DashboardRegistry.getInstance().getDashboardItems(DashboardManagerDialog.this.getDashboardProviderFor(parentMap, dspd), (DBPNamedObject)dspd, false);
                } else if (parentElement instanceof DBPDriver) {
                    DBPDriver driver = (DBPDriver)parentElement;
                    result = DashboardRegistry.getInstance().getDashboardItems(DashboardManagerDialog.this.getDashboardProviderFor(parentMap, driver), (DBPNamedObject)driver, false);
                }
                if (result == null) {
                    return new Object[0];
                }
                for (Object child : result) {
                    parentMap.put(child, parentElement);
                }
                result.sort(DBUtils.nameComparator());
                return result.toArray();
            }

            public boolean hasChildren(Object element) {
                return !(element instanceof DashboardItemConfiguration);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(this){

            public void update(ViewerCell cell) {
                DBPNamedObject element = (DBPNamedObject)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    cell.setText(element.getName());
                    if (element instanceof DBPDriver) {
                        DBPDriver driver = (DBPDriver)element;
                        cell.setImage(DBeaverIcons.getImage((DBPImage)driver.getIcon()));
                    } else if (element instanceof DashboardProviderDescriptor) {
                        DashboardProviderDescriptor dpd = (DashboardProviderDescriptor)element;
                        cell.setImage(DBeaverIcons.getImage((DBPImage)dpd.getIcon()));
                    } else if (element instanceof DBPDataSourceProviderDescriptor) {
                        DBPDataSourceProviderDescriptor dspd = (DBPDataSourceProviderDescriptor)element;
                        cell.setImage(DBeaverIcons.getImage((DBPImage)dspd.getIcon()));
                    } else if (element instanceof DashboardItemConfiguration) {
                        DashboardItemConfiguration dashboardDescriptor = (DashboardItemConfiguration)element;
                        DBIcon icon = null;
                        if (dashboardDescriptor.isCustom()) {
                            icon = DBIcon.TYPE_OBJECT;
                        } else {
                            DashboardRendererDescriptor viewType = DashboardUIRegistry.getInstance().getViewType(dashboardDescriptor.getDashboardRenderer());
                            if (viewType != null) {
                                icon = viewType.getIcon();
                            }
                        }
                        if (icon != null) {
                            cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                        }
                    }
                } else if (element instanceof DBPDriver) {
                    DBPDriver driver = (DBPDriver)element;
                    cell.setText(CommonUtils.notEmpty((String)driver.getDescription()));
                } else if (element instanceof DashboardProviderDescriptor) {
                    DashboardProviderDescriptor dpd = (DashboardProviderDescriptor)element;
                    cell.setText(dpd.getDescription());
                } else if (element instanceof DBPDataSourceProviderDescriptor) {
                    DBPDataSourceProviderDescriptor dspd = (DBPDataSourceProviderDescriptor)element;
                    cell.setText(dspd.getDescription());
                }
            }
        });
        this.setViewerInput();
        this.treeViewer.addDoubleClickListener(event -> {
            if (this.selectedDashboard != null) {
                this.editDashboard();
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            IStructuredSelection ss;
            Object selectedObject;
            this.selectedDashboard = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selectedObject = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof DashboardItemConfiguration) {
                DashboardItemConfiguration dd;
                this.selectedDashboard = dd = (DashboardItemConfiguration)selectedObject;
            }
            this.updateButtons();
        });
        UIUtils.asyncExec(() -> {
            this.treeViewer.expandToLevel(2);
            UIUtils.packColumns((Tree)this.treeViewer.getTree(), (boolean)true, null);
        });
        Composite buttonBar = new Composite(group, 128);
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        GridData gd2 = new GridData(1040);
        buttonBar.setLayoutData((Object)gd2);
        List dashboardProviderDescriptors = DashboardRegistry.getInstance().getDashboardProvidersWithSupportCustomDashboards();
        for (final DashboardProviderDescriptor dashboardProvider : dashboardProviderDescriptors) {
            Button newChartButton = UIUtils.createPushButton((Composite)buttonBar, (String)NLS.bind((String)UIDashboardMessages.dialog_dashboard_manager_button_new, (Object)dashboardProvider.getLabel()), null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DashboardManagerDialog.this.createDashboard(dashboardProvider);
                }
            });
            newChartButton.setLayoutData((Object)new GridData(768));
        }
        this.copyButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_copy, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.copyDashboard();
            }
        });
        this.copyButton.setLayoutData((Object)new GridData(768));
        this.editButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_edit, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.editDashboard();
            }
        });
        this.editButton.setLayoutData((Object)new GridData(768));
        this.deleteButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_delete, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.deleteDashboard();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(768));
        UIUtils.createInfoLabel((Composite)dialogArea, (String)UIDashboardMessages.dialog_dashboard_manager_infolabel_predifined_dashboard);
        this.updateButtons();
        return group;
    }

    private void setViewerInput() {
        ArrayList<DashboardProviderDescriptor> providers = new ArrayList<DashboardProviderDescriptor>(DashboardRegistry.getInstance().getDashboardProviders());
        providers.removeIf(dpd -> !dpd.isSupportsCustomDashboards());
        this.treeViewer.setInput(providers);
    }

    private DashboardProviderDescriptor getDashboardProviderFor(Map<Object, Object> parentMap, Object element) {
        Object item = element;
        while (item != null) {
            if (item instanceof DashboardProviderDescriptor) {
                DashboardProviderDescriptor dpd = (DashboardProviderDescriptor)item;
                return dpd;
            }
            item = parentMap.get(item);
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(0);
            this.close();
        }
    }

    private void updateButtons() {
        this.copyButton.setEnabled(this.selectedDashboard != null);
        this.editButton.setEnabled(this.selectedDashboard != null);
        this.deleteButton.setEnabled(this.selectedDashboard != null && this.selectedDashboard.isCustom());
    }

    private void createDashboard(DashboardProviderDescriptor providerDescriptor) {
        DashboardItemConfiguration newDashboard = new DashboardItemConfiguration(providerDescriptor, null, "", "", "", "", true);
        newDashboard.setRenderer(providerDescriptor.getDefaultRenderer());
        newDashboard.setDataType(providerDescriptor.getDataType());
        DashboardItemConfigurationDialog editDialog = new DashboardItemConfigurationDialog(this.getShell(), newDashboard, true);
        if (editDialog.open() == 0) {
            DashboardRegistry.getInstance().createDashboardItem(newDashboard);
            this.refreshDashboards();
        }
    }

    private void copyDashboard() {
        DashboardItemConfiguration newDashboard = new DashboardItemConfiguration(this.selectedDashboard);
        newDashboard.setCustom(true);
        String origId = newDashboard.getId();
        int i = 2;
        while (DashboardRegistry.getInstance().getDashboardItem(newDashboard.getId()) != null) {
            newDashboard.setId(origId + " " + i);
            ++i;
        }
        DashboardItemConfigurationDialog editDialog = new DashboardItemConfigurationDialog(this.getShell(), newDashboard, true);
        if (editDialog.open() == 0) {
            DashboardRegistry.getInstance().createDashboardItem(newDashboard);
            this.refreshDashboards();
        }
    }

    private void editDashboard() {
        DashboardItemConfigurationDialog editDialog = new DashboardItemConfigurationDialog(this.getShell(), this.selectedDashboard, false);
        if (editDialog.open() == 0) {
            DashboardRegistry.getInstance().saveSettings();
            this.refreshDashboards();
        }
    }

    private void deleteDashboard() {
        if (this.selectedDashboard == null || !this.selectedDashboard.isCustom()) {
            return;
        }
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)UIDashboardMessages.dialog_dashboard_manager_shell_delete_title, (String)NLS.bind((String)UIDashboardMessages.dialog_dashboard_manager_shell_delete_question, (Object)this.selectedDashboard.getName()))) {
            DashboardRegistry.getInstance().removeDashboardItem(this.selectedDashboard);
            this.selectedDashboard = null;
            this.refreshDashboards();
        }
    }

    private void refreshDashboards() {
        this.setViewerInput();
        this.treeViewer.expandToLevel(2);
        this.updateButtons();
    }

    private static class DashboardTreeViewer
    extends TreeViewer {
        public DashboardTreeViewer(Composite group) {
            super(group, 2048);
        }
    }
}

