/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.ui.editors.erd.connector.ERDConnection;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.ui.editors.erd.part.AssociationPart;
import org.jkiss.dbeaver.ui.editors.erd.part.AttributePart;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.dbeaver.utils.ListNode;

public class ERDHighlightingManager {
    private static final Log log = Log.getLog(ERDHighlightingManager.class);
    @NotNull
    private final Map<IFigure, PartHighlighter> highlightedParts = new HashMap<IFigure, PartHighlighter>();

    @NotNull
    public ERDHighlightingHandle highlight(@NotNull IFigure part, @NotNull Color color) {
        return this.highlightedParts.computeIfAbsent(part, x$0 -> new PartHighlighter((IFigure)x$0)).highlight(color);
    }

    @Nullable
    public ERDHighlightingHandle makeHighlightingGroupHandle(@Nullable ListNode<ERDHighlightingHandle> highlightings) {
        if (highlightings == null) {
            return null;
        }
        return () -> {
            for (ERDHighlightingHandle highlighting : highlightings) {
                highlighting.release();
            }
        };
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightRelatedAttributes(@NotNull AttributePart attributePart, @NotNull Color color) {
        AssociationPart associationPart;
        EditPart editPart = attributePart.getParent();
        if (!(editPart instanceof EntityPart)) {
            return null;
        }
        EntityPart entityPart = (EntityPart)editPart;
        ListNode highlightings = null;
        for (AssociationPart associationPart2 : attributePart.getAssociatingBySource()) {
            if (!associationPart2.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart2.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join(highlightings, this.highlightRelatedAttributes(associationPart2, color));
        }
        for (AssociationPart associationPart2 : attributePart.getAssociatingByTarget()) {
            if (!associationPart2.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart2.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart2, color));
        }
        for (AssociationPart connection : entityPart.getSourceConnections()) {
            if (!(connection instanceof AssociationPart) || !(associationPart = connection).getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart, color));
        }
        for (AssociationPart connection : entityPart.getTargetConnections()) {
            if (!(connection instanceof AssociationPart) || !(associationPart = connection).getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart, color));
        }
        return highlightings;
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightRelatedAttributes(@NotNull AssociationPart associationPart, @NotNull Color color) {
        ListNode highlightings = null;
        EntityPart sourceEntityPart = null;
        EditPart editPart = associationPart.getSource();
        if (editPart instanceof EntityPart) {
            EntityPart entityPartFromSource;
            sourceEntityPart = entityPartFromSource = (EntityPart)editPart;
        } else {
            EditPart editPart2 = associationPart.getSource().getParent();
            if (editPart2 instanceof EntityPart) {
                EntityPart entityPartFromParent = (EntityPart)editPart2;
                sourceEntityPart = entityPartFromParent;
            }
        }
        List<AttributePart> sourcePartAttributes = this.getEntityAttributes(sourceEntityPart, associationPart.getAssociation().getSourceAttributes());
        for (AttributePart attributePart : sourcePartAttributes) {
            highlightings = ListNode.push(highlightings, (Object)this.highlight((IFigure)attributePart.getFigure(), color));
        }
        EditPart editPart3 = associationPart.getSource();
        if (editPart3 instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)editPart3;
            for (AttributePart attrPart3 : this.getEntityAttributes(entityPart, associationPart.getAssociation().getSourceAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart3.getFigure(), color));
            }
        }
        EntityPart targetEntityPart = null;
        Object object = associationPart.getTarget();
        if (object instanceof EntityPart) {
            EntityPart entityPart;
            targetEntityPart = entityPart = (EntityPart)object;
        } else {
            object = associationPart.getTarget().getParent();
            if (object instanceof EntityPart) {
                EntityPart entityPartFromParent = (EntityPart)object;
                targetEntityPart = entityPartFromParent;
            }
        }
        List<AttributePart> list = this.getEntityAttributes(targetEntityPart, associationPart.getAssociation().getTargetAttributes());
        for (AttributePart attrPart4 : list) {
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart4.getFigure(), color));
        }
        object = associationPart.getTarget();
        if (object instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)object;
            for (AttributePart attrPart5 : this.getEntityAttributes(entityPart, associationPart.getAssociation().getTargetAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart5.getFigure(), color));
            }
        }
        return highlightings;
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightAssociation(@Nullable ListNode<ERDHighlightingHandle> highlightings, @NotNull AssociationPart associationPart, @NotNull Color color) {
        Connection connection = associationPart.getConnectionFigure();
        if (connection instanceof ERDConnection) {
            ERDConnection erdConnection;
            erdConnection.setSelected(!(erdConnection = (ERDConnection)connection).isSelected());
        }
        highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        return highlightings;
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightAssociation(@Nullable ListNode<ERDHighlightingHandle> highlightings, @NotNull AttributePart attributePart, @NotNull Color color) {
        EditPart editPart;
        Object object;
        List associatingBySource = attributePart.getAssociatingBySource();
        if ((associatingBySource == null || associatingBySource.isEmpty()) && (object = attributePart.getParent()) instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)object;
            associatingBySource = entityPart.getSourceConnections();
        }
        for (AssociationPart associationPart : associatingBySource) {
            if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        }
        List associatingByTarget = attributePart.getAssociatingByTarget();
        if ((associatingByTarget == null || associatingByTarget.isEmpty()) && (editPart = attributePart.getParent()) instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)editPart;
            associatingByTarget = entityPart.getTargetConnections();
        }
        for (AssociationPart associationPart : associatingByTarget) {
            if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        }
        return highlightings;
    }

    @NotNull
    private List<AttributePart> getEntityAttributes(@NotNull EntityPart source, @NotNull List<ERDEntityAttribute> columns) {
        ArrayList<AttributePart> result = new ArrayList<AttributePart>(columns.size());
        for (Object attrPart : source.getChildren()) {
            if (!(attrPart instanceof AttributePart) || !columns.contains(((AttributePart)attrPart).getAttribute())) continue;
            result.add((AttributePart)attrPart);
        }
        return result;
    }

    private final class PartHighlighter {
        @NotNull
        private final IFigure part;
        @NotNull
        private final Color originalColor;
        private final boolean originalOpaque;
        @NotNull
        private final LinkedList<HighlightingEntry> highlightings = new LinkedList();

        public PartHighlighter(IFigure part) {
            this.originalColor = part instanceof Connection ? part.getForegroundColor() : part.getBackgroundColor();
            this.originalOpaque = part.isOpaque();
            this.part = part;
        }

        private void refresh() {
            try {
                if (this.highlightings.isEmpty()) {
                    IFigure iFigure = this.part;
                    if (iFigure instanceof ERDConnection) {
                        ERDConnection connection = (ERDConnection)iFigure;
                        connection.setSelected(false);
                        this.part.setForegroundColor(this.originalColor);
                    } else {
                        this.part.setBackgroundColor(this.originalColor);
                    }
                    this.part.setOpaque(this.originalOpaque);
                } else {
                    IFigure iFigure = this.part;
                    if (iFigure instanceof ERDConnection) {
                        ERDConnection connection = (ERDConnection)iFigure;
                        connection.setSelected(true);
                        this.part.setForegroundColor(this.highlightings.getLast().color);
                    } else {
                        this.part.setBackgroundColor(this.highlightings.getLast().color);
                    }
                    this.part.setOpaque(true);
                }
                this.part.repaint();
            }
            catch (Throwable ex) {
                log.warn((Object)"Inconsistent highlighting management detected during figure props refresh.", ex);
            }
        }

        @NotNull
        public ERDHighlightingHandle highlight(@NotNull Color color) {
            HighlightingEntry entry = new HighlightingEntry(color);
            this.highlightings.addLast(entry);
            this.refresh();
            return () -> {
                this.highlightings.remove(entry);
                if (this.highlightings.isEmpty()) {
                    ERDHighlightingManager.this.highlightedParts.remove(this.part);
                }
                this.refresh();
            };
        }
    }

    private static final class HighlightingEntry {
        public final Color color;

        public HighlightingEntry(@NotNull Color color) {
            this.color = color;
        }
    }
}

