/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public abstract class AltibaseProcedureBase
extends GenericProcedure
implements DBSObjectWithScript,
DBPStatefulObject,
DBPRefreshableObject {
    protected static final Log log = Log.getLog(AltibaseProcedureBase.class);
    protected String schemaName = null;
    protected boolean valid = false;
    protected List<GenericProcedureParameter> columns;
    protected DBSProcedureType procedureType;

    public AltibaseProcedureBase(GenericStructContainer container, String procedureName, boolean valid, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        super(container, procedureName, procedureName, "", procedureType, functionResultType);
        this.schemaName = container.getName();
        this.procedureType = procedureType;
        this.valid = valid;
    }

    public void addColumn(GenericProcedureParameter column) {
        if (this.columns == null) {
            this.columns = new ArrayList<GenericProcedureParameter>();
        }
        this.columns.add(new AltibaseProcedureParameter(column));
    }

    @Nullable
    public Collection<GenericProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.columns == null) {
            this.loadProcedureColumns(monitor);
        }
        return this.columns;
    }

    @Property(viewable=false, hidden=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=false, hidden=true, order=3, labelProvider=GenericCatalog.CatalogNameTermProvider.class)
    public GenericCatalog getCatalog() {
        return ((GenericStructContainer)this.getContainer()).getCatalog();
    }

    @Property(viewable=false, hidden=true, order=7)
    public GenericFunctionResultType getFunctionResultType() {
        return super.getFunctionResultType();
    }

    public void setProcedureType(DBSProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    public String getProcedureTypeName() {
        if (this.procedureType == DBSProcedureType.UNKNOWN) {
            return "TYPESET";
        }
        return this.procedureType.name();
    }

    @Property(hidden=true, editable=true, updatable=true)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return super.getObjectDefinitionText(monitor, options);
    }

    public void setObjectDefinitionText(String source) {
        super.setSource(source);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void refreshState(JDBCSession session) throws DBCException {
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT status FROM system_.sys_users_ u, system_.sys_procedures_ p WHERE u.user_id = p.user_id AND u.user_name = ? AND proc_name = ?");){
            dbStat.setString(1, this.schemaName);
            dbStat.setString(2, this.getName());
            dbStat.executeStatement();
            try (JDBCResultSet dbResult = dbStat.getResultSet();){
                if (dbResult != null && dbResult.next()) {
                    this.valid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)1, (String)"0");
                }
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Refresh state of " + this.getProcedureTypeName() + " '" + this.getName() + "'"));){
            this.refreshState(session);
        }
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Refresh state of " + this.getProcedureTypeName() + " '" + this.getName() + "'"));){
            this.refreshState(session);
        }
        return this;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }
}

