# Generated by Django 3.2.12 on 2022-03-23 07:59

from django.db import migrations
from django.conf import settings
import logging

logger = logging.getLogger(__name__)


def migrate_from_settings_file(apps, schema_editor):

    if hasattr(settings, 'FEATURE_FINDING_GROUPS'):
        system_settings_model = apps.get_model('dojo', 'System_Settings')
        logger.info('Migrating value from FEATURE_FINDING_GROUPS into system settings model')
        try:
            system_setting = system_settings_model.objects.get()
            system_setting.enable_finding_groups = settings.FEATURE_FINDING_GROUPS
            system_setting.save()
        except:
            # for a clean installation there is no system_settings record, so just ignore it
            pass


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0155_enable_finding_groups'),
    ]

    operations = [
        migrations.RunPython(migrate_from_settings_file),
    ]
