/* 
 *  Stupid Simple Sample: MMS WAP Get using jWAP
 *
 *  Collin Mulliner <collin(AT)betaversion.net>
 *
 *  License: GPLv2
 *
 */

import java.net.SocketException;
import java.net.UnknownHostException;

import net.sourceforge.jwap.GetRequest;
import net.sourceforge.jwap.PostRequest;
import net.sourceforge.jwap.Request;
import net.sourceforge.jwap.Response;
import net.sourceforge.jwap.WAPClient;

import java.io.File;

public class MMSGetClient
{
	public static void main(String[] args) throws UnknownHostException, SocketException, IllegalStateException
	{
		if (args.length != 2) {
			System.out.println("syntax: <URL> <OUTFILE>");
			System.out.println("\nWAP Gateway address is fixed, recompile me to change it!");
			System.exit(0);
		}

		System.out.println("getting MMS url: " + args[0] + "\n");
	
		// create a WAP client communicating with a WAP gateway
		// WAPClient(IP, port)
		//WAPClient client = new WAPClient("127.0.0.1", 9201); // localhost
		WAPClient client = new WAPClient("212.23.97.153", 9201); // eplus (germnay) 
		//WAPClient client = new WAPClient("10.250.250.100", 9201); // cingular (usa)
		//WAPClient client = new WAPClient("216.155.165.50", 9201); // t-mobile (usa)


		// connect to gw, 60 sec timeout
		client.connect(60000);

		try {
			// build the get request
			GetRequest req = new GetRequest(args[0]);

			// execute the request with 90 sec timeout
			Response resp = client.execute(req, 90000);

			System.out.println(resp);
			try {
				// save the response
				java.io.FileOutputStream fout = new java.io.FileOutputStream(args[1]);
				fout.write(resp.getResponseBody());
				fout.close();
			} catch (java.io.IOException ioe) {
				System.out.println("can't save output");
			}
			System.out.println(new String(resp.getResponseBody()));
                                                                                                   
		} finally {
			// disconnect from the gw
			client.disconnect();
		}
	}
}
