#include "ximage.h"

#define PRF_ID_LEN sizeof(prf_id)
u_char prf_id[] = { 'P', 'R', 'F', '1' };

/*
 */
#define BITS_MASK (32-1)
#define PLANES_MASK (3<<5)
#define PRF_HDR_LEN sizeof(prf_t)
struct _prf_t {
    u_char  id[4];
    uint32_t    width, height;
    u_char  bp; /* 7-5: planes 4:0 bits */
} __attribute__((packed));
typedef struct _prf_t prf_t;

int ximage_prf_fill(ximage_t *xp)
{
    prf_t   prfh;
    u_char  buf[BS];
    int len = 0;
   
    /* set up PRF header */
    memcpy(&prfh.id, prf_id, PRF_ID_LEN);
    prfh.width = htonl(0x8000000);
    prfh.height = htonl(0x800000);
    prfh.bp = 0x60;

    memcpy(buf, &prfh, PRF_HDR_LEN);
    len += PRF_HDR_LEN;
    memset(buf+len, 'A', 512);
    len += 512;

    /* allocate output buffer */
    xp->buf = calloc(1, len);
    if(xp->buf == NULL)
        die("calloc");
    xp->buflen = len;

    /* copy out data */
    memcpy(xp->buf, buf, len);
    
    return 0;
}

int ximage_prf_clean(ximage_t *xp)
{
    free(xp->buf);
    return 0;
}

int ximage_prf_init(ximage_t *xp)
{
    return 0;
}
