#ifndef _NTDLL_H
#define _NTDLL_H

#ifdef _MSC_VER
#pragma pack(push,8)
#endif  // _MSC_VER

#ifdef __cplusplus
extern "C"  {
#endif

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef OPTIONAL
#define OPTIONAL
#endif

#if (defined(_M_MRX000) || defined(_M_IX86) || \
defined(_M_ALPHA) || defined(_M_PPC)) && !defined(MIDL_PASS)
#define DECLSPEC_IMPORT __declspec(dllimport)
#else
#define DECLSPEC_IMPORT
#endif


#if (_MSC_VER >= 800) || defined(_STDCALL_SUPPORTED)
#define NTAPI __stdcall
#else
#define _cdecl
#define NTAPI
#endif

#if !defined(_NTSYSTEM_)
#define NTSYSAPI DECLSPEC_IMPORT
#else
#define NTSYSAPI DECLSPEC_EXPORT
#endif

#ifndef CONST
#define CONST const
#endif

#ifndef VOID
#define VOID void
typedef char CHAR;
typedef short SHORT;
typedef long LONG;
#endif

typedef void *PVOID;

#define FALSE 0
#define TRUE 1

#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else NULL ((void *)0)
#endif
#endif // NULL

// char wchar

#ifndef _WCHAR_T_DEFINED
typedef unsigned short wchar_t;
#define _WCHAR_T_DEFINED
#endif

typedef wchar_t WCHAR;
typedef WCHAR *LPWSTR, *PWSTR;
typedef CONST WCHAR *LPCWSTR, *PCWSTR;
typedef CHAR *LPSTR, *PSTR;
typedef CONST CHAR *LPCSTR, *PCSTR;

#define UNICODE_NULL ((WCHAR)0)

typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned long ULONG;
typedef UCHAR *PUCHAR;
typedef USHORT *PUSHORT;
typedef ULONG *PULONG;

typedef void *HANDLE;
typedef HANDLE *PHANDLE;
typedef UCHAR BOOLEAN;
typedef BOOLEAN *PBOOLEAN;
typedef long NTSTATUS;

#ifndef _WINNT_

typedef struct _LARGE_INTEGER {
     ULONG LowPart;
     LONG HighPart;
} LARGE_INTEGER, *PLARGE_INTEGER;

typedef struct _ULARGE_INTEGER {
     ULONG LowPart;
     ULONG HighPart;
} ULARGE_INTEGER, *PULONG_INTEGER;

typedef LARGE_INTEGER LUID, *PLUID;

#endif

// unicode string

typedef struct _UNICODE_STRING {
     USHORT Length;
     USHORT MaximumLength;
     PWSTR Buffer;
} UNICODE_STRING;
typedef UNICODE_STRING *PUNICODE_STRING;


typedef int FILE_INFORMATION_CLASS;

typedef
NTSYSAPI
VOID
NTAPI 
_RtlInitUnicodeString(
     OUT PUNICODE_STRING DestanationString,
     IN PCWSTR SourceString
     );

// Object atributes
#define OBJ_INHERIT           0x00000002L
#define OBJ_PERMANENT         0x00000010L
#define OBJ_EXCLUSIVE         0x00000020L
#define OBJ_CASE_INSENSITIVE  0x00000040L
#define OBJ_OPENIF            0x00000080L
#define OBJ_VALID_ATTRIBUTES  0x000000f2L

typedef struct _OBJECT_ATTRIBUTES {
   ULONG Length;
   HANDLE RootDirectory;
   PUNICODE_STRING ObjectName;
   ULONG Attributes;
   PVOID SecurityDescriptor;
   PVOID SecurityQualityOfService;
} OBJECT_ATTRIBUTES, *POBJECT_ATTRIBUTES;

//++
//
// VOID
// InitializeObjectAttributes(
//     OUT POBJECT_ATTRIBUTES p,
//     IN PUNICODE_STRING n,
//     IN ULONG a,
//     IN HANDLE r,
//     IN PSECURITY_DESCRIPTOR s
//     )
//
//--

#define InitializeObjectAttributes( p, n, a, r, s ) { \
    (p)->Length = sizeof( OBJECT_ATTRIBUTES );          \
    (p)->RootDirectory = r;                             \
    (p)->Attributes = a;                                \
    (p)->ObjectName = n;                                \
    (p)->SecurityDescriptor = s;                        \
    (p)->SecurityQualityOfService = NULL;               \
    }


#define OBJ_NAME_PATH_SEPARATOR ((WCHAR)L'\\'}

// Access rights

typedef ULONG ACCESS_MASK;

#define DELETE                   (0x00010000L)
#define READ_CONTROL             (0x00020000L)
#define WRITE_DAC                (0x00040000L)
#define WRITE_OWNER                 (0x00080000L)
#define SYNCHRONIZE                 (0x00100000L)

#define ACCESS_SYSTEM_SECURITY         (0x01000000L)
#define MAXIMUM_ALLOWED             (0x02000000L)
#define GENERIC_READ                    (0x80000000L)
#define GENERIC_WRITE                   (0x40000000L)
#define GENERIC_EXECUTE                 (0x20000000L)
#define GENERIC_ALL                     (0x10000000L)

typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwOpenSymbolicLinkObject(
    OUT PHANDLE LinkHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes
    );

#define SYMBOLIC_LINK_QUERY (0x0001)


typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwQuerySymbolicLinkObject(
    IN HANDLE LinkHandle,
    IN OUT PUNICODE_STRING LinkTarget,
    OUT PULONG ReturnedLength OPTIONAL
    );

typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwClose(
    IN HANDLE Handle
    );


typedef struct _IO_STATUS_BLOCK {
    union {
        NTSTATUS Status;
        PVOID Pointer;
    };

    ULONG_PTR Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;


//
// Define the file attributes values
//
// Note:  0x00000008 is reserved for use for the old DOS VOLID (volume ID)
//        and is therefore not considered valid in NT.
//
// Note:  0x00000010 is reserved for use for the old DOS SUBDIRECTORY flag
//        and is therefore not considered valid in NT.  This flag has
//        been disassociated with file attributes since the other flags are
//        protected with READ_ and WRITE_ATTRIBUTES access to the file.
//
// Note:  Note also that the order of these flags is set to allow both the
//        FAT and the Pinball File Systems to directly set the attributes
//        flags in attributes words without having to pick each flag out
//        individually.  The order of these flags should not be changed!
//

#define FILE_ATTRIBUTE_READONLY             0x00000001  // winnt
#define FILE_ATTRIBUTE_HIDDEN               0x00000002  // winnt
#define FILE_ATTRIBUTE_SYSTEM               0x00000004  // winnt
//OLD DOS VOLID                             0x00000008

#define FILE_ATTRIBUTE_DIRECTORY            0x00000010  // winnt
#define FILE_ATTRIBUTE_ARCHIVE              0x00000020  // winnt
#define FILE_ATTRIBUTE_DEVICE               0x00000040  // winnt
#define FILE_ATTRIBUTE_NORMAL               0x00000080  // winnt

#define FILE_ATTRIBUTE_TEMPORARY            0x00000100  // winnt
#define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200  // winnt
#define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400  // winnt
#define FILE_ATTRIBUTE_COMPRESSED           0x00000800  // winnt

#define FILE_ATTRIBUTE_OFFLINE              0x00001000  // winnt
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000  // winnt
#define FILE_ATTRIBUTE_ENCRYPTED            0x00004000  // winnt

//
//  This definition is old and will disappear shortly
//

#define FILE_ATTRIBUTE_CONTENT_INDEXED      FILE_ATTRIBUTE_NOT_CONTENT_INDEXED

#define FILE_ATTRIBUTE_VALID_FLAGS      0x00007fb7
#define FILE_ATTRIBUTE_VALID_SET_FLAGS  0x000031a7

//
// Define the create disposition values
//

#define FILE_SUPERSEDE                  0x00000000
#define FILE_OPEN                       0x00000001
#define FILE_CREATE                     0x00000002
#define FILE_OPEN_IF                    0x00000003
#define FILE_OVERWRITE                  0x00000004
#define FILE_OVERWRITE_IF               0x00000005
#define FILE_MAXIMUM_DISPOSITION        0x00000005

//
// Define the create/open option flags
//

#define FILE_DIRECTORY_FILE                     0x00000001
#define FILE_WRITE_THROUGH                      0x00000002
#define FILE_SEQUENTIAL_ONLY                    0x00000004
#define FILE_NO_INTERMEDIATE_BUFFERING          0x00000008

#define FILE_SYNCHRONOUS_IO_ALERT               0x00000010
#define FILE_SYNCHRONOUS_IO_NONALERT            0x00000020
#define FILE_NON_DIRECTORY_FILE                 0x00000040
#define FILE_CREATE_TREE_CONNECTION             0x00000080

#define FILE_COMPLETE_IF_OPLOCKED               0x00000100
#define FILE_NO_EA_KNOWLEDGE                    0x00000200
#define FILE_OPEN_FOR_RECOVERY                  0x00000400
#define FILE_RANDOM_ACCESS                      0x00000800

#define FILE_DELETE_ON_CLOSE                    0x00001000
#define FILE_OPEN_BY_FILE_ID                    0x00002000
#define FILE_OPEN_FOR_BACKUP_INTENT             0x00004000
#define FILE_NO_COMPRESSION                     0x00008000

#define FILE_RESERVE_OPFILTER                   0x00100000
#define FILE_OPEN_REPARSE_POINT                 0x00200000
#define FILE_OPEN_NO_RECALL                     0x00400000
#define FILE_OPEN_FOR_FREE_SPACE_QUERY          0x00800000

#define FILE_COPY_STRUCTURED_STORAGE            0x00000041
#define FILE_STRUCTURED_STORAGE                 0x00000441

#define FILE_VALID_OPTION_FLAGS                 0x00ffffff
#define FILE_VALID_PIPE_OPTION_FLAGS            0x00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS        0x00000032
#define FILE_VALID_SET_FLAGS                    0x00000036

//
// Define the I/O status information return values for NtCreateFile/NtOpenFile
//

#define FILE_SUPERSEDED                 0x00000000
#define FILE_OPENED                     0x00000001
#define FILE_CREATED                    0x00000002
#define FILE_OVERWRITTEN                0x00000003
#define FILE_EXISTS                     0x00000004
#define FILE_DOES_NOT_EXIST             0x00000005


typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwCreateFile(
    OUT PHANDLE FileHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes,
    OUT PIO_STATUS_BLOCK IoStatusBlock,
    IN PLARGE_INTEGER AllocationSize OPTIONAL,
    IN ULONG FileAttributes,
    IN ULONG ShareAccess,
    IN ULONG CreateDisposition,
    IN ULONG CreateOptions,
    IN PVOID EaBuffer OPTIONAL,
    IN ULONG EaLength
    );

typedef struct _FILE_FULL_EA_INFORMATION {
    ULONG NextEntryOffset;
    UCHAR Flags;
    UCHAR EaNameLength;
    USHORT EaValueLength;
    CHAR EaName[1];
} FILE_FULL_EA_INFORMATION, *PFILE_FULL_EA_INFORMATION;


typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwQueryEaFile(
   IN HANDLE FileHandle,
   OUT PIO_STATUS_BLOCK IoStatusBlock,
   OUT PFILE_FULL_EA_INFORMATION Buffer,
   IN ULONG BufferLength,
   IN BOOLEAN ReturnSingleEntry,
   IN PVOID EaList OPTIONAL,
   IN ULONG EaListLength,
   IN PULONG EaIndex,
   IN BOOLEAN RestartScan
);


typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwSetEaFile(
   IN HANDLE FileHandle,
   OUT PIO_STATUS_BLOCK IoStatusBlock,
   IN PFILE_FULL_EA_INFORMATION Buffer,
   IN ULONG BufferLength
);

typedef enum _SYSTEM_INFORMATION_CLASS {
   SystemBasicInformation, // 0 Y N
   SystemProcessorInformation, // 1 Y N
   SystemPerformanceInformation, // 2 Y N
   SystemTimeOfDayInformation, // 3 Y N
   SystemNotImplemented1, // 4 Y N
   SystemProcessesAndThreadsInformation, // 5 Y N
   SystemCallCounts, // 6 Y N
   SystemConfigurationInformation, // 7 Y N
   SystemProcessorTimes, // 8 Y N
   SystemGlobalFlag, // 9 Y Y
   SystemNotImplemented2, // 10 Y N
   SystemModuleInformation, // 11 Y N
   SystemLockInformation, // 12 Y N
   SystemNotImplemented3, // 13 Y N
   SystemNotImplemented4, // 14 Y N
   SystemNotImplemented5, // 15 Y N
   SystemHandleInformation, // 16 Y N
   SystemObjectInformation, // 17 Y N
   SystemPagefileInformation, // 18 Y N
   SystemInstructionEmulationCounts, // 19 Y N
   SystemInvalidInfoClass1, // 20
   SystemCacheInformation, // 21 Y Y
   SystemPoolTagInformation, // 22 Y N
   SystemProcessorStatistics, // 23 Y N
   SystemDpcInformation, // 24 Y Y
   SystemNotImplemented6, // 25 Y N
   SystemLoadImage, // 26 N Y
   SystemUnloadImage, // 27 N Y
   SystemTimeAdjustment, // 28 Y Y
   SystemNotImplemented7, // 29 Y N
   SystemNotImplemented8, // 30 Y N
   SystemNotImplemented9, // 31 Y N
   SystemCrashDumpInformation, // 32 Y N
   SystemExceptionInformation, // 33 Y N
   SystemCrashDumpStateInformation, // 34 Y Y/N
   SystemKernelDebuggerInformation, // 35 Y N
   SystemContextSwitchInformation, // 36 Y N
   SystemRegistryQuotaInformation, // 37 Y Y
   SystemLoadAndCallImage, // 38 N Y
   SystemPrioritySeparation, // 39 N Y
   SystemNotImplemented10, // 40 Y N
   SystemNotImplemented11, // 41 Y N
   SystemInvalidInfoClass2, // 42
   SystemInvalidInfoClass3, // 43
   SystemTimeZoneInformation, // 44 Y N
   SystemLookasideInformation, // 45 Y N
   SystemSetTimeSlipEvent, // 46 N Y
   SystemCreateSession, // 47 N Y
   SystemDeleteSession, // 48 N Y
   SystemInvalidInfoClass4, // 49
   SystemRangeStartInformation, // 50 Y N
   SystemVerifierInformation, // 51 Y Y
   SystemAddVerifier, // 52 N Y
   SystemSessionProcessesInformation // 53 Y N
} SYSTEM_INFORMATION_CLASS;

typedef LONG KPRIORITY;


typedef struct _VM_COUNTERS {
    SIZE_T PeakVirtualSize;
    SIZE_T VirtualSize;
    ULONG PageFaultCount;
    SIZE_T PeakWorkingSetSize;
    SIZE_T WorkingSetSize;
    SIZE_T QuotaPeakPagedPoolUsage;
    SIZE_T QuotaPagedPoolUsage;
    SIZE_T QuotaPeakNonPagedPoolUsage;
    SIZE_T QuotaNonPagedPoolUsage;
    SIZE_T PagefileUsage;
    SIZE_T PeakPagefileUsage;
} VM_COUNTERS;
typedef VM_COUNTERS *PVM_COUNTERS;

typedef struct _CLIENT_ID {
    HANDLE UniqueProcess;
    HANDLE UniqueThread;
} CLIENT_ID;
typedef CLIENT_ID *PCLIENT_ID;

typedef enum _KWAIT_REASON {
    Executive,
    FreePage,
    PageIn,
    PoolAllocation,
    DelayExecution,
    Suspended,
    UserRequest,
    WrExecutive,
    WrFreePage,
    WrPageIn,
    WrPoolAllocation,
    WrDelayExecution,
    WrSuspended,
    WrUserRequest,
    WrEventPair,
    WrQueue,
    WrLpcReceive,
    WrLpcReply,
    WrVirtualMemory,
    WrPageOut,
    WrRendezvous,
    Spare2,
    Spare3,
    Spare4,
    Spare5,
    Spare6,
    WrKernel,
    MaximumWaitReason
} KWAIT_REASON;


typedef ULONG THREAD_STATE;

typedef struct _SYSTEM_THREADS {
   LARGE_INTEGER KernelTime;
   LARGE_INTEGER UserTime;
   LARGE_INTEGER CreateTime;
   ULONG WaitTime;
   PVOID StartAddress;
   CLIENT_ID ClientId;
   KPRIORITY Priority;
   KPRIORITY BasePriority;
   ULONG ContextSwitchCount;
   THREAD_STATE State;
   KWAIT_REASON WaitReason;
} SYSTEM_THREADS, *PSYSTEM_THREADS;


typedef struct _SYSTEM_PROCESSES { // Information Class 5
   ULONG NextEntryDelta;
   ULONG ThreadCount;
   ULONG Reserved1[6];
   LARGE_INTEGER CreateTime;
   LARGE_INTEGER UserTime;
   LARGE_INTEGER KernelTime;
   UNICODE_STRING ProcessName;
   KPRIORITY BasePriority;
   ULONG ProcessId;
   ULONG InheritedFromProcessId;
   ULONG HandleCount;
   ULONG Reserved2[2];
   VM_COUNTERS VmCounters;
   IO_COUNTERS IoCounters; // Windows 2000 only
   SYSTEM_THREADS Threads[1];
} SYSTEM_PROCESSES, *PSYSTEM_PROCESSES;

typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwQuerySystemInformation(
    IN SYSTEM_INFORMATION_CLASS SystemInformationClass,
    IN OUT PVOID SystemInformation,
    IN ULONG SystemInformationLength,
    OUT PULONG ReturnLength OPTIONAL
    );

typedef
NTSTATUS 
NTAPI
_ZwOpenKey(
    OUT PHANDLE KeyHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes
    );
typedef
NTSYSAPI
NTSTATUS
NTAPI
_ZwCreateKey(
	OUT PHANDLE KeyHandle,
	IN ACCESS_MASK DesiredAccess,
	IN POBJECT_ATTRIBUTES ObjectAttributes,
	IN ULONG TitleIndex,
	IN PUNICODE_STRING Class OPTIONAL,
	IN ULONG CreateOptions,
	OUT PULONG Disposition OPTIONAL
	); 
#define NT_SUCCESS(Status) ((NTSTATUS)(Status) >= 0)


#ifdef __cplusplus
}
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif  // _MSC_VER

#endif // _NT_DLL_


